/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sdsu.compare.StringIgnoreCaseComparer;
import sdsu.util.SortedList;

public class Prefs
extends Hashtable {
    String userDirectory = "Muffin";
    boolean allowOverride = true;

    public Prefs(int n) {
        super(n);
    }

    public Prefs() {
    }

    public void setUserDirectory(String string) {
        this.userDirectory = string;
    }

    public String getUserDirectory() {
        if (this.userDirectory.startsWith(System.getProperty("file.separator"))) {
            return this.userDirectory;
        }
        return String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + this.userDirectory;
    }

    void checkUserDirectory() {
        File file = new File(this.getUserDirectory());
        if (!file.exists()) {
            System.out.println("Creating " + this.getUserDirectory());
            if (!file.mkdirs()) {
                System.out.println("Can't create " + this.getUserDirectory());
            }
        }
    }

    public String getUserFile(String string) {
        return String.valueOf(this.getUserDirectory()) + System.getProperty("file.separator") + string;
    }

    public boolean exists(Object object) {
        return this.containsKey(object);
    }

    public synchronized Object put(Object object, Object object2) {
        if (this.allowOverride || !this.exists(object)) {
            return super.put(object, object2);
        }
        return null;
    }

    public void setOverride(boolean bl) {
        this.allowOverride = bl;
    }

    public boolean getOverride() {
        return this.allowOverride;
    }

    public void putString(String string, String string2) {
        this.put(string, string2);
    }

    public void putBoolean(String string, boolean bl) {
        this.put(string, bl ? "true" : "false");
    }

    public void putInteger(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public String getString(String string) {
        return (String)this.get(string);
    }

    public boolean getBoolean(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return false;
        }
        return "true".equalsIgnoreCase(string2);
    }

    public int getInteger(String string) {
        int n;
        try {
            n = Integer.parseInt(this.getString(string));
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public Prefs extract(String string) {
        Prefs prefs = new Prefs();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(String.valueOf(string) + ".")) continue;
            prefs.put(string2, this.get(string2));
        }
        return prefs;
    }

    public void merge(Prefs prefs) {
        Enumeration enumeration = prefs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.put(string, prefs.get(string));
        }
    }

    public String[] getStringList(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = new String(stringTokenizer.nextToken());
            ++n;
        }
        return stringArray;
    }

    public void putStringList(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n != stringArray.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        this.putString(string, stringBuffer.toString());
    }

    public void print() {
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(" * " + string + " = " + this.get(string));
        }
    }

    public synchronized Enumeration sortedKeys() {
        Enumeration enumeration = this.keys();
        SortedList sortedList = new SortedList(StringIgnoreCaseComparer.getInstance());
        while (enumeration.hasMoreElements()) {
            sortedList.addElement((String)enumeration.nextElement());
        }
        return sortedList.elements();
    }
}

