/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.io.DataOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import muffin.FilterManager;
import muffin.Handler;
import muffin.HttpError;
import muffin.Httpd;
import muffin.Monitor;
import muffin.Options;

public class Server {
    ServerSocket server;
    ThreadGroup handlers;
    Monitor monitor;
    FilterManager manager;
    Options options;
    boolean running = false;

    public Server(int n, Monitor monitor, FilterManager filterManager, Options options) {
        try {
            this.server = new ServerSocket(n, 512);
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.exit(0);
        }
        this.handlers = new ThreadGroup("Handlers");
        this.monitor = monitor;
        this.manager = filterManager;
        this.options = options;
        Httpd.init(options, filterManager);
    }

    public void suspend() {
        this.running = false;
    }

    public void resume() {
        this.running = true;
    }

    public synchronized void stop() {
        int n = this.handlers.activeCount();
        if (n < 0) {
            return;
        }
        Thread[] threadArray = new Thread[n];
        this.handlers.enumerate(threadArray);
        int n2 = 0;
        while (n2 < n) {
            Handler handler = (Handler)threadArray[n2];
            handler.close();
            ++n2;
        }
    }

    public void run() {
        this.running = true;
        while (true) {
            Socket socket;
            try {
                socket = this.server.accept();
            }
            catch (Exception exception) {
                System.out.println(exception);
                continue;
            }
            if (!this.options.hostAccess(socket.getInetAddress())) {
                System.out.println(String.valueOf(socket.getInetAddress()) + ": access denied");
                this.error(socket, 403, "No muffins for you!");
                continue;
            }
            if (this.running) {
                Handler handler = new Handler(this.handlers, (Runnable)Thread.currentThread(), this.monitor, this.manager, this.options);
                handler.doit(socket);
                continue;
            }
            this.error(socket, 503, "Muffin proxy service is suspended.");
        }
    }

    void error(Socket socket, int n, String string) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.writeBytes(new HttpError(this.options, n, string).toString());
            dataOutputStream.close();
            socket.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

