/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import muffin.ContentFilter;
import muffin.FilterException;
import muffin.Prefs;
import muffin.Reply;
import muffin.ReplyFilter;
import muffin.Request;
import muffin.RequestFilter;
import muffin.filter.AnimationKiller;

public class AnimationKillerFilter
implements RequestFilter,
ReplyFilter,
ContentFilter {
    Prefs prefs;
    AnimationKiller factory;
    InputStream in;
    OutputStream out;
    Request request;

    AnimationKillerFilter(AnimationKiller animationKiller) {
        this.factory = animationKiller;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public void filter(Request request) throws FilterException {
        this.request = request;
    }

    public void filter(Reply reply) throws FilterException {
        String string = reply.getHeaderField("Content-type");
        if (string != null && string.startsWith("multipart/x-mixed-replace")) {
            this.factory.process("Found server push " + this.request.getURL() + "\n");
            throw new FilterException("Killed server push " + this.request.getURL());
        }
    }

    public boolean needsFiltration(Request request, Reply reply) {
        String string = reply.getHeaderField("Content-type");
        if (string == null) {
            return false;
        }
        return string.startsWith("image/gif");
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void run() {
        try {
            int n;
            int[] nArray = new int[]{33, 255, 11, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 35, 35};
            int[] nArray2 = new int[nArray.length];
            int n2 = 0;
            boolean bl = false;
            PushbackInputStream pushbackInputStream = new PushbackInputStream(this.in);
            while ((n = pushbackInputStream.read()) != -1) {
                if (bl) {
                    this.out.write(n);
                    continue;
                }
                if (n == nArray[n2] || nArray[n2] == 63 && n >= 32 && n <= 126 || nArray[n2] == 35) {
                    nArray2[n2] = n;
                    if (++n2 != nArray.length) continue;
                    n2 = 0;
                    bl = true;
                    this.factory.process("Found GIF animation " + this.request.getURL() + "\n");
                    if (this.prefs.getBoolean("AnimationKiller.break")) {
                        while ((n = pushbackInputStream.read()) != -1) {
                        }
                        break;
                    }
                    String string = null;
                    if (this.prefs.getInteger("AnimationKiller.maxLoops") == -1) {
                        this.out.write(33);
                        this.out.write(254);
                        string = new String("MUFFINED2.0");
                    } else {
                        this.out.write(33);
                        this.out.write(255);
                        string = new String("NETSCAPE2.0");
                    }
                    this.out.write(11);
                    this.out.write(string.getBytes(), 0, string.length());
                    this.out.write(3);
                    this.out.write(1);
                    n = pushbackInputStream.read();
                    n = pushbackInputStream.read();
                    if (this.prefs.getInteger("AnimationKiller.maxLoops") == -1) {
                        this.out.write(0);
                        this.out.write(0);
                        continue;
                    }
                    this.out.write(this.prefs.getInteger("AnimationKiller.maxLoops"));
                    this.out.write(0);
                    continue;
                }
                if (n2 > 0) {
                    int n3 = 0;
                    while (n3 < n2) {
                        this.out.write(nArray2[n3]);
                        ++n3;
                    }
                    pushbackInputStream.unread(n);
                    n2 = 0;
                    continue;
                }
                this.out.write(n);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

