/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import muffin.Cookie;
import muffin.FilterException;
import muffin.Prefs;
import muffin.Reply;
import muffin.ReplyFilter;
import muffin.Request;
import muffin.RequestFilter;
import muffin.filter.CookieMonster;

public class CookieMonsterFilter
implements RequestFilter,
ReplyFilter {
    Prefs prefs;
    CookieMonster factory;
    Request request;

    CookieMonsterFilter(CookieMonster cookieMonster) {
        this.factory = cookieMonster;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public void filter(Request request) throws FilterException {
        this.request = request;
        if (request.containsHeaderField("Cookie") && this.prefs.getBoolean("CookieMonster.eatRequestCookies")) {
            request.getHeaderField("Cookie");
            request.removeHeaderField("Cookie");
        }
    }

    public void filter(Reply reply) throws FilterException {
        if (reply.containsHeaderField("Set-Cookie")) {
            Cookie cookie = new Cookie(reply.getHeaderField("Set-Cookie"), this.request);
            if (this.prefs.getBoolean("CookieMonster.eatReplyCookies")) {
                this.factory.process(cookie);
                reply.removeHeaderField("Set-Cookie");
            }
        }
    }
}

