/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.io.InputStream;
import java.io.OutputStream;
import muffin.ContentFilter;
import muffin.Prefs;
import muffin.Reply;
import muffin.Request;
import muffin.filter.Decaf;
import muffin.html.HtmlTokenizer;
import muffin.html.Tag;

public class DecafFilter
implements ContentFilter {
    Decaf factory;
    Prefs prefs;
    InputStream in;
    OutputStream out;
    Request request;

    DecafFilter(Decaf decaf) {
        this.factory = decaf;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        String string = reply.getHeaderField("Content-type");
        return string != null && string.startsWith("text/html");
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void run() {
        try {
            int n;
            HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this.in);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = this.prefs.getBoolean("Decaf.noJavaScript");
            boolean bl4 = this.prefs.getBoolean("Decaf.noJava");
            while ((n = htmlTokenizer.getToken()) != -1) {
                if (n == -2) {
                    Tag tag = htmlTokenizer.getTag();
                    if (bl && tag.is("/script")) {
                        bl = false;
                        continue;
                    }
                    if (bl2 && tag.is("/applet")) {
                        bl2 = false;
                        continue;
                    }
                    if (bl3) {
                        if (tag.is("script")) {
                            bl = true;
                            this.factory.process("Removing JavaScript from " + this.request.getURL() + "\n");
                        } else if (this.factory.isJavaScriptTag(tag.name())) {
                            tag.remove("onblur");
                            tag.remove("onchange");
                            tag.remove("onclick");
                            tag.remove("onfocus");
                            tag.remove("onload");
                            tag.remove("onmouseover");
                            tag.remove("onmouseout");
                            tag.remove("onselect");
                            tag.remove("onsubmit");
                            tag.remove("onunload");
                            if (tag.has("href") && tag.get("href").startsWith("javascript:")) {
                                tag.remove("href");
                            }
                            if (tag.has("language") && tag.get("language").equalsIgnoreCase("javascript")) {
                                tag.remove("language");
                            }
                        }
                    }
                    if (bl4 && tag.is("applet")) {
                        bl2 = true;
                        this.factory.process("Removing Java from " + this.request.getURL() + "\n");
                    }
                    if (bl || bl2) continue;
                    htmlTokenizer.writeTag(tag, this.out);
                    continue;
                }
                if (bl || bl2) continue;
                htmlTokenizer.writeToken(this.out);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

