/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.io.InputStream;
import java.io.OutputStream;
import muffin.ContentFilter;
import muffin.Prefs;
import muffin.Reply;
import muffin.Request;
import muffin.filter.Painter;
import muffin.html.HtmlTokenizer;
import muffin.html.Tag;

public class PainterFilter
implements ContentFilter {
    Painter factory;
    Prefs prefs;
    InputStream in;
    OutputStream out;
    Request request;

    PainterFilter(Painter painter) {
        this.factory = painter;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        String string = reply.getHeaderField("Content-type");
        return string != null && string.startsWith("text/html");
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void run() {
        try {
            int n;
            HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this.in);
            while ((n = htmlTokenizer.getToken()) != -1) {
                if (n == -2) {
                    String string;
                    Tag tag = htmlTokenizer.getTag();
                    if (tag.is("body")) {
                        string = this.prefs.getString("Painter.bgcolor");
                        if (string.length() > 0) {
                            if (string.equalsIgnoreCase("None")) {
                                tag.remove("bgcolor");
                                tag.remove("background");
                            } else {
                                tag.put("bgcolor", string);
                                tag.remove("background");
                            }
                        } else {
                            string = this.prefs.getString("Painter.background");
                            if (string.length() > 0) {
                                if (string.equalsIgnoreCase("None")) {
                                    tag.remove("background");
                                    tag.remove("bgcolor");
                                } else {
                                    tag.put("background", string);
                                    tag.remove("bgcolor");
                                }
                            }
                        }
                        string = this.prefs.getString("Painter.text");
                        if (string.length() > 0) {
                            if (string.equalsIgnoreCase("None")) {
                                tag.remove("text");
                            } else {
                                tag.put("text", string);
                            }
                        }
                        if ((string = this.prefs.getString("Painter.link")).length() > 0) {
                            if (string.equalsIgnoreCase("None")) {
                                tag.remove("link");
                            } else {
                                tag.put("link", string);
                            }
                        }
                        if ((string = this.prefs.getString("Painter.alink")).length() > 0) {
                            if (string.equalsIgnoreCase("None")) {
                                tag.remove("alink");
                            } else {
                                tag.put("alink", string);
                            }
                        }
                        if ((string = this.prefs.getString("Painter.vlink")).length() > 0) {
                            if (string.equalsIgnoreCase("None")) {
                                tag.remove("vlink");
                            } else {
                                tag.put("vlink", string);
                            }
                        }
                    } else if (tag.is("font") && tag.has("color")) {
                        string = this.prefs.getString("Painter.text");
                        if (string.length() > 0) {
                            if (string.equalsIgnoreCase("None")) {
                                tag.remove("color");
                            } else {
                                tag.put("color", string);
                            }
                        }
                    } else if ((tag.is("table") || tag.is("tr") || tag.is("th") || tag.is("td")) && tag.has("bgcolor") && (string = this.prefs.getString("Painter.bgcolor")).length() > 0) {
                        if (string.equalsIgnoreCase("None")) {
                            tag.remove("bgcolor");
                        } else {
                            tag.put("bgcolor", string);
                        }
                    }
                    htmlTokenizer.writeTag(tag, this.out);
                    continue;
                }
                htmlTokenizer.writeToken(this.out);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

