/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Vector;
import muffin.Prefs;
import muffin.filter.ColorSample;
import muffin.filter.Painter;

public class PainterFrame
extends Frame
implements ActionListener,
WindowListener,
ItemListener {
    Prefs prefs;
    Painter parent;
    TextField bgcolor;
    TextField link;
    TextField alink;
    TextField vlink;
    TextField background;
    TextField text;
    ColorSample bgcolorSample;
    ColorSample linkSample;
    ColorSample alinkSample;
    ColorSample vlinkSample;
    ColorSample textSample;
    Hashtable styleTable;
    String[] styles = new String[]{"None", "Dark", "Light", "Christmas"};

    public PainterFrame(Prefs prefs, Painter painter) {
        super("Painter");
        this.prefs = prefs;
        this.parent = painter;
        ((Component)this).setBackground(Color.lightGray);
        ((Component)this).setFont(new Font("Helvetica", 1, 12));
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        Label label = new Label("Sample Colors:", 2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.createStyleTable();
        Choice choice = new Choice();
        choice.addItemListener(this);
        int n = 0;
        while (n < this.styles.length) {
            choice.addItem(this.styles[n]);
            ++n;
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(choice, gridBagConstraints);
        panel.add(choice);
        label = new Label("Background Image:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.background = new TextField(32);
        ((TextComponent)this.background).setText(prefs.getString("Painter.background"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.background, gridBagConstraints);
        panel.add(this.background);
        label = new Label("Background Color:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.bgcolor = new TextField(7);
        ((TextComponent)this.bgcolor).setText(prefs.getString("Painter.bgcolor"));
        this.bgcolor.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(this.bgcolor, gridBagConstraints);
        panel.add(this.bgcolor);
        this.bgcolorSample = new ColorSample(prefs.getString("Painter.bgcolor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.bgcolorSample, gridBagConstraints);
        panel.add(this.bgcolorSample);
        label = new Label("Text Color:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.text = new TextField(7);
        ((TextComponent)this.text).setText(prefs.getString("Painter.text"));
        this.text.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(this.text, gridBagConstraints);
        panel.add(this.text);
        this.textSample = new ColorSample(prefs.getString("Painter.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.textSample, gridBagConstraints);
        panel.add(this.textSample);
        label = new Label("Link Color:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.link = new TextField(7);
        ((TextComponent)this.link).setText(prefs.getString("Painter.link"));
        this.link.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(this.link, gridBagConstraints);
        panel.add(this.link);
        this.linkSample = new ColorSample(prefs.getString("Painter.link"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.linkSample, gridBagConstraints);
        panel.add(this.linkSample);
        label = new Label("Visited Link Color:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.vlink = new TextField(7);
        ((TextComponent)this.vlink).setText(prefs.getString("Painter.vlink"));
        this.vlink.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(this.vlink, gridBagConstraints);
        panel.add(this.vlink);
        this.vlinkSample = new ColorSample(prefs.getString("Painter.vlink"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.vlinkSample, gridBagConstraints);
        panel.add(this.vlinkSample);
        label = new Label("Active Link Color:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.alink = new TextField(7);
        ((TextComponent)this.alink).setText(prefs.getString("Painter.alink"));
        this.alink.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(this.alink, gridBagConstraints);
        panel.add(this.alink);
        this.alinkSample = new ColorSample(prefs.getString("Painter.alink"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.alinkSample, gridBagConstraints);
        panel.add(this.alinkSample);
        this.add("Center", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 4));
        Button button = new Button("Apply");
        button.setActionCommand("doApply");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Save");
        button.setActionCommand("doSave");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Close");
        button.setActionCommand("doClose");
        button.addActionListener(this);
        panel2.add(button);
        this.add("South", panel2);
        this.addWindowListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
        this.show();
    }

    void createStyleTable() {
        this.styleTable = new Hashtable(13);
        Vector<String> vector = new Vector<String>();
        vector.addElement("None");
        vector.addElement("None");
        vector.addElement("None");
        vector.addElement("None");
        vector.addElement("None");
        this.styleTable.put(this.styles[0], vector);
        vector = new Vector();
        vector.addElement("#000000");
        vector.addElement("#ffffff");
        vector.addElement("#98fb98");
        vector.addElement("#ffa07a");
        vector.addElement("#ff0000");
        this.styleTable.put(this.styles[1], vector);
        vector = new Vector();
        vector.addElement("#ffffff");
        vector.addElement("#000000");
        vector.addElement("#0000ee");
        vector.addElement("#551a8b");
        vector.addElement("#ff0000");
        this.styleTable.put(this.styles[2], vector);
        vector = new Vector();
        vector.addElement("#ffffff");
        vector.addElement("#000000");
        vector.addElement("#00ff00");
        vector.addElement("#ff0000");
        vector.addElement("#ff0000");
        this.styleTable.put(this.styles[3], vector);
    }

    void updateSamples() {
        this.bgcolorSample.setColor(this.bgcolor.getText());
        this.textSample.setColor(this.text.getText());
        this.linkSample.setColor(this.link.getText());
        this.vlinkSample.setColor(this.vlink.getText());
        this.alinkSample.setColor(this.alink.getText());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("doApply".equals(string)) {
            this.prefs.putString("Painter.bgcolor", this.bgcolor.getText());
            this.prefs.putString("Painter.background", this.background.getText());
            this.prefs.putString("Painter.text", this.text.getText());
            this.prefs.putString("Painter.link", this.link.getText());
            this.prefs.putString("Painter.vlink", this.vlink.getText());
            this.prefs.putString("Painter.alink", this.alink.getText());
            this.updateSamples();
            return;
        }
        if ("doSave".equals(string)) {
            this.parent.save();
            return;
        }
        if ("doClose".equals(string)) {
            ((Component)this).setVisible(false);
            return;
        }
        if (actionEvent.getSource() == this.bgcolor) {
            this.bgcolorSample.setColor(this.bgcolor.getText());
            return;
        }
        if (actionEvent.getSource() == this.text) {
            this.textSample.setColor(this.text.getText());
            return;
        }
        if (actionEvent.getSource() == this.link) {
            this.linkSample.setColor(this.link.getText());
            return;
        }
        if (actionEvent.getSource() == this.vlink) {
            this.vlinkSample.setColor(this.vlink.getText());
            return;
        }
        if (actionEvent.getSource() == this.alink) {
            this.alinkSample.setColor(this.alink.getText());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Vector vector = (Vector)this.styleTable.get(itemEvent.getItem().toString());
        ((TextComponent)this.bgcolor).setText((String)vector.elementAt(0));
        ((TextComponent)this.text).setText((String)vector.elementAt(1));
        ((TextComponent)this.link).setText((String)vector.elementAt(2));
        ((TextComponent)this.vlink).setText((String)vector.elementAt(3));
        ((TextComponent)this.alink).setText((String)vector.elementAt(4));
        this.updateSamples();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

