/*
 * Decompiled with CFR 0.152.
 */
package muffin.html;

import java.util.Enumeration;
import java.util.Hashtable;
import sdsu.util.SimpleTokenizer;
import sdsu.util.TokenCharacters;

public class Tag {
    protected String name = "";
    protected byte[] contents;
    protected int contentsIndex = -1;
    protected int contentsEnd = -1;
    private Hashtable attributes;
    private boolean parsed = false;
    private boolean modified = false;

    private void parse() {
        this.parsed = true;
        if (this.contentsEnd - this.contentsIndex <= 0 || this.name.length() <= 0 || this.name.startsWith("<!doctype")) {
            return;
        }
        try {
            String string = new String(this.contents, this.contentsIndex, this.contentsEnd - this.contentsIndex);
            TokenCharacters tokenCharacters = new TokenCharacters("", "", '\"', '\"', " \t\r\n");
            tokenCharacters.addQuoteChars('\'', '\'');
            SimpleTokenizer simpleTokenizer = new SimpleTokenizer(string, tokenCharacters);
            simpleTokenizer.setEatEscapeChar(false);
            while (simpleTokenizer.hasMoreTokens()) {
                String string2 = simpleTokenizer.nextToken("=");
                String string3 = simpleTokenizer.separator() == '=' ? simpleTokenizer.nextToken("") : "";
                this.put(string2, string3);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public String name() {
        return this.name;
    }

    public boolean is(String string) {
        return this.name.equals(string);
    }

    public boolean has(String string) {
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes != null) {
            return this.attributes.containsKey(string);
        }
        return false;
    }

    public String get(String string) {
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes != null) {
            return (String)this.attributes.get(string);
        }
        return null;
    }

    public void put(String string, String string2) {
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable(13);
        }
        this.attributes.put(string.toLowerCase(), string2);
        this.modified = true;
    }

    public void remove(String string) {
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes != null) {
            this.attributes.remove(string);
            this.modified = true;
        }
    }

    public void rename(String string) {
        this.name = string;
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String toString() {
        if (!this.parsed) {
            this.parse();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.name);
        if (this.attributes != null && !this.attributes.isEmpty()) {
            Enumeration enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append(" ");
                stringBuffer.append(string);
                String string2 = this.get(string);
                if (string2.length() <= 0) continue;
                stringBuffer.append("=");
                stringBuffer.append("\"");
                stringBuffer.append(string2);
                stringBuffer.append("\"");
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

