/* About.java */

/* 
 * Copyright (C) 1996-97 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;

/**
 * Create an about window.
 *
 * @author Mark Boyns
 */
public class About extends Frame implements ActionListener, WindowListener
{
    /**
     * Create About.
     *
     */
    public About (Options options)
    {
	super ("About Muffin");

	setBackground (Color.lightGray);
	setFont (new Font ("Helvetica", Font.BOLD, 12));

	Panel panel = new Panel ();
	GridBagLayout layout = new GridBagLayout ();
	GridBagConstraints c;
	Label l;
	panel.setLayout (layout);
	panel.setBackground (Color.white);

 	l = new Label ("Muffin");
 	l.setFont (new Font ("Helvetica", Font.BOLD, 24));
 	c = new GridBagConstraints ();
 	c.gridwidth = GridBagConstraints.REMAINDER;
 	layout.setConstraints (l, c);
 	panel.add (l);

	l = new Label ("version " + options.getString ("muffin.version"));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);
	
	l = new Label ("by Mark Boyns <boyns@sdsu.edu>");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.gridheight = 5;
	layout.setConstraints (l, c);
	panel.add (l);
	
	l = new Label ("Computer Development Research Group");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);

	ImageCanvas sdsu = new ImageCanvas ("images/sdsu.jpg", null, false);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (sdsu, c);
	panel.add (sdsu);
	
	l = new Label ("San Diego State University");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	c.insets = new Insets (0, 0, 0, 0);
	layout.setConstraints (l, c);
	panel.add (l);
	
	ImageCanvas logo = new ImageCanvas ("images/muffin.jpg", null, false);
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (logo, c);
	panel.add (logo);

	l = new Label ("Muffin logo by Rebecca Smith");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);
	
	l = new Label ("More information is available here:");
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);
	
	l = new Label (options.getString ("muffin.url"));
	c = new GridBagConstraints ();
	c.gridwidth = GridBagConstraints.REMAINDER;
	layout.setConstraints (l, c);
	panel.add (l);
	
	add ("Center", panel);

	Button b = new Button ("OK");
	b.addActionListener (this);
	add ("South", b);

	addWindowListener (this);

	pack ();
	setSize (getPreferredSize ());
	show ();
    }

    /**
     * Hide the frame on button events.
     *
     * @param event some event
     */
    public void actionPerformed (ActionEvent event)
    {
	setVisible (false);
    }

    public void windowActivated (WindowEvent e)
    {
    }
  
    public void windowDeactivated (WindowEvent e)
    {
    }
  
    public void windowClosing (WindowEvent e)
    {
	setVisible (false);
    }
  
    public void windowClosed (WindowEvent e)
    {
    }
  
    public void windowIconified (WindowEvent e)
    {
    }
  
    public void windowDeiconified (WindowEvent e)
    {
    }
  
    public void windowOpened (WindowEvent e)
    {
    }
}
