/* DecafFilter.java -- Go ahead... enable javascript. */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filter;

import muffin.*;
import muffin.html.*;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class DecafFilter implements ContentFilter
{
    Decaf factory;
    Prefs prefs;
    InputStream in = null;
    OutputStream out = null;
    Request request = null;

    DecafFilter (Decaf factory)
    {
	this.factory = factory;
    }
    
    public void setPrefs (Prefs prefs)
    {
	this.prefs = prefs;
    }

    public boolean needsFiltration (Request request, Reply reply)
    {
	this.request = request;
	String s = reply.getHeaderField ("Content-type");
	return s != null && s.startsWith ("text/html");
    }
    
    public void setInputStream (InputStream in)
    {
	this.in = in;
    }

    public void setOutputStream (OutputStream out)
    {
	this.out = out;
    }
    
    public void run ()
    {
	try
	{
	    HtmlTokenizer html = new HtmlTokenizer (in);
	    int token;
	    Tag tag;
	    boolean eatingJavaScript = false;
	    boolean eatingJava = false;
	    boolean noJavaScript = prefs.getBoolean ("Decaf.noJavaScript");
	    boolean noJava = prefs.getBoolean ("Decaf.noJava");

            while ((token = html.getToken ()) != HtmlTokenizer.TT_EOF)
            {
		if (token == HtmlTokenizer.TT_TAG)
		{
		    tag = html.getTag ();

		    if (eatingJavaScript && tag.is ("/script"))
		    {
			eatingJavaScript = false;
			continue;
		    }
		    if (eatingJava && tag.is ("/applet"))
		    {
			eatingJava = false;
			continue;
		    }
		    
		    if (noJavaScript)
		    {
			if (tag.is ("script"))
			{
			    eatingJavaScript = true;
			    factory.process ("Removing JavaScript from " + request.getURL () + "\n");
			}
			else if (factory.isJavaScriptTag (tag.name ()))
			{
			    tag.remove ("onblur");
			    tag.remove ("onchange");
			    tag.remove ("onclick");
			    tag.remove ("onfocus");
			    tag.remove ("onload");
			    tag.remove ("onmouseover");
			    tag.remove ("onmouseout");
			    tag.remove ("onselect");
			    tag.remove ("onsubmit");
			    tag.remove ("onunload");
			    if (tag.has ("href")
				&& tag.get ("href").startsWith ("javascript:"))
			    {
				tag.remove ("href");
			    }
			    if (tag.has ("language")
				&& tag.get ("language").equalsIgnoreCase ("javascript"))
			    {
				tag.remove ("language");
			    }
			}
		    }
		    if (noJava)
		    {
			if (tag.is ("applet"))
			{
			    eatingJava = true;
			    factory.process ("Removing Java from " + request.getURL () + "\n");
			}
		    }
		    if (!eatingJavaScript && !eatingJava)
		    {
			html.writeTag (tag, out);
		    }
		}
		else if (!eatingJavaScript && !eatingJava)
		{
		    html.writeToken (out);
		}
	    }
	    
	    out.flush ();
	    out.close ();
	}
	catch (Exception e)
	{
	    e.printStackTrace ();
	}
    }
}

