/* PreviewFilter.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filter;

import muffin.*;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.awt.Frame;

public class PreviewFilter implements ContentFilter
{
    Preview factory;
    Prefs prefs;
    InputStream in = null;
    OutputStream out = null;
    Reply reply;
    Request request;

    PreviewFilter (Preview factory)
    {
	this.factory = factory;
    }

    public void setPrefs (Prefs prefs)
    {
	this.prefs = prefs;
    }

    public boolean needsFiltration (Request request, Reply reply)
    {
	this.request = request;
	this.reply = reply;

	String type = reply.getHeaderField ("Content-type");
	if (type == null)
	{
	    return false;
	}

	if (prefs.getString ("Preview.contentTypes").equals ("ALL"))
	{
	    return true;
	}
	
	String previewTypes[] = prefs.getStringList ("Preview.contentTypes");
	for (int i = 0; i < previewTypes.length; i++)
	{
	    if (type.startsWith (previewTypes[i]))
	    {
		return true;
	    }
	}
	
	return false;
    }
    
    public void setInputStream (InputStream in)
    {
	this.in = in;
    }

    public void setOutputStream (OutputStream out)
    {
	this.out = out;
    }

    public void run ()
    {
	try
	{
	    byte buffer[] = new byte[8192];
	    byte content[] = { (byte)0 };
	    int n;
	    ByteArrayOutputStream outbuf = new ByteArrayOutputStream ();

	    while ((n = in.read (buffer, 0, buffer.length)) > 0)
	    {
		outbuf.write (buffer, 0, n);
	    }

	    synchronized (factory.previewFrame)
	    {
		PreviewDialog dialog = new PreviewDialog (factory.previewFrame,
							  request, reply, outbuf.toByteArray ());
		dialog.show ();
		if (dialog.accept ())
		{
		    content = dialog.getContent ();
		}
		dialog.dispose ();
	    }
	    
	    out.write (content, 0, content.length);
	    out.flush ();
	    out.close ();

	}
	catch (Exception e)
	{
	    e.printStackTrace ();
	}
    }
}
