/* HtmlTokenizer.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.html;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.BufferedInputStream;
import java.io.PushbackInputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class HtmlTokenizer extends PushbackInputStream
{
    public Token getToken () throws IOException
    {
	int ch;
	boolean quoted = false;
	int quoteChar = 0;
	Token token = new Token ();
	
	while ((ch = read ()) != -1)
	{
	    if (token.type != Token.TT_COMMENT)
	    {
		/* look for end quote */
		if (quoted)
		{
		    if (ch == quoteChar)
		    {
			quoted = false;
		    }
		}
		/* look for start tag */
		else if (ch == '<')
		{
		    if (token.type != Token.TT_NONE)
		    {
			unread (ch);
			return token.type;
		    }
		    token.type = Token.TT_TAG;
		}
		/* look for start quote */
		else if (token.type == Token.TT_TAG && (ch == '"' || ch == '\''))
		{
		    quoted = true;
		    quoteChar = ch;
		}
		/* otherwise it's text */
		else if (token.type == 0)
		{
		    token.type = Token.TT_TEXT;
		}
	    }

	    token.append ((byte) ch);

	    /* see if the tag is really a comment */
	    if (token.type == Token.TT_TAG && token.offset == 4)
	    {
		if (token.buf[0] == '<'
		    && token.buf[1] == '!'
		    && token.buf[2] == '-'
		    && token.buf[3] == '-')
		{
		    token.type = Token.TT_COMMENT;
		}
	    }

	    /* look for end tag */
	    if (ch == '>' && !quoted && (token.type == Token.TT_TAG || token.type == Token.TT_COMMENT))
	    {
		if (token.type == Token.TT_COMMENT)
		{
		    if (token.buf[token.offset-1] == '>'
			&& token.buf[token.offset-2] == '-'
			&& token.buf[token.offset-3] == '-')
		    {
			break;
		    }
		}
		else
		{
		    break;
		}
	    }
	}

	if (type.type == Token.TT_NONE)
	{
	    type.type = Token.TT_EOF;
	}

	return token;
    }
}
