/* Token.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.html;

import java.io.OutputStream;
import java.io.IOException;

public class Token
{
    public static final int TT_NONE = -1;
    public static final int TT_EOF = -1;
    public static final int TT_TAG = -2;
    public static final int TT_TEXT = -4;
    public static final int TT_COMMENT = -8;

    protected int type = TT_NONE;
    protected byte buf[];
    protected final int bufSize = 1024;
    protected int offset = 0;

    Token ()
    {
	buf = new byte[bufSize];
    }

    protected void append (byte ch)
    {
	if (offset == buf.length)
	{
	    byte tmpbuf[] = buf;
	    buf = new byte[tmpbuf.length * 2];
	    System.arraycopy (tmpbuf, 0, buf, 0, offset);
	}
	buf[offset++] = ch;
    }

    public int getType ()
    {
	return type;
    }

    public String toString ()
    {
	return new String (buf, 0, offset);
    }

    public Tag getTag ()
    {
	int start = 0, end = 0, rest = 0;

	while (start < offset)
	{
	    switch (buf[++start])
	    {
	    case ' ':
	    case '\t':
	    case '\r':
	    case '\n':
	    case '>':
		continue;
	    }
	    break;
	}

	end = start;
 loop:  while (end < offset)
	{
	    switch (buf[++end])
	    {
	    case ' ':
	    case '\t':
	    case '\r':
	    case '\n':
		rest = end+1;
		break loop;
		
	    case '>':
		rest = -1;
		break loop;
	    }
	}

	Tag tag = new Tag ();
	tag.name = new String (buf, start, end - start).toLowerCase ();
	if (rest > 0)
	{
	    tag.contents = buf;
	    tag.contentsIndex = rest;
	    tag.contentsEnd = offset - 1; // strip '>'
	}
	return tag;
    }

    public void writeToken (OutputStream out) throws IOException
    {
	out.write (buf, 0, offset);
    }

    public void writeTag (OutputStream out) throws IOException
    {
	if (tag.isModified ())
	{
	    String s = tag.toString ();
	    out.write (s.getBytes (), 0, s.length ());
	}
	else
	{
	    writeToken (out);
	}
    }
}
