/*
 * Decompiled with CFR 0.152.
 */
package JP.ac.osaka_u.ender.util.regex;

import JP.ac.osaka_u.ender.util.regex.NFABuildException;
import JP.ac.osaka_u.ender.util.regex.RTree;
import JP.ac.osaka_u.ender.util.regex.RegExpDFA;
import JP.ac.osaka_u.ender.util.regex.RegExpDebug;
import JP.ac.osaka_u.ender.util.regex.RegExpNFA;
import JP.ac.osaka_u.ender.util.regex.RegExpParser;
import JP.ac.osaka_u.ender.util.regex.RegExpSyntaxException;

class RegExpCore {
    protected String pattern;
    protected RegExpDFA dfa;

    public RegExpCore() {
    }

    public RegExpCore(String string) throws RegExpSyntaxException, NFABuildException {
        this.setPattern(string);
    }

    public void setPattern(String string) throws RegExpSyntaxException, NFABuildException {
        this.pattern = string;
        RegExpParser regExpParser = new RegExpParser();
        RTree rTree = regExpParser.parse(string);
        RegExpNFA regExpNFA = new RegExpNFA(rTree);
        this.dfa = new RegExpDFA(regExpNFA);
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    public String treeString() {
        return RegExpDebug.treeToString(this.dfa.getTree());
    }

    public String nfaString() {
        return RegExpDebug.nfaToString(this.dfa.getNfa());
    }

    public String dfaString() {
        return RegExpDebug.dfaToString(this.dfa);
    }
}

