/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import muffin.Configuration;
import muffin.ConfigurationListener;
import muffin.Options;
import muffin.UserPrefs;

class OptionsFrame
extends Frame
implements ActionListener,
WindowListener,
ConfigurationListener {
    Options options;
    Configuration configs;
    TextField httpProxyHost;
    TextField httpProxyPort;
    TextField hostsAllowList;
    TextField hostsDenyList;
    TextField adminAllowList;
    TextField adminDenyList;

    OptionsFrame(Options options, Configuration configuration) {
        super("Muffin: Options");
        this.options = options;
        this.configs = configuration;
        ((Component)this).setBackground(Color.lightGray);
        ((Component)this).setFont(new Font("Helvetica", 1, 12));
        this.setResizable(false);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        Label label = new Label();
        label.setFont(new Font("Fixed", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        Label label2 = new Label("HTTP Proxy:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel.add(label2);
        this.httpProxyHost = new TextField(20);
        ((TextComponent)this.httpProxyHost).setText(options.getString("muffin.httpProxyHost"));
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(this.httpProxyHost, gridBagConstraints);
        panel.add(this.httpProxyHost);
        label2 = new Label("Port:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel.add(label2);
        this.httpProxyPort = new TextField(10);
        ((TextComponent)this.httpProxyPort).setText(options.getString("muffin.httpProxyPort"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.httpProxyPort, gridBagConstraints);
        panel.add(this.httpProxyPort);
        label2 = new Label("HostsAllow:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel.add(label2);
        this.hostsAllowList = new TextField(50);
        ((TextComponent)this.hostsAllowList).setText(options.getString("muffin.hostsAllow"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.hostsAllowList, gridBagConstraints);
        panel.add(this.hostsAllowList);
        label2 = new Label("HostsDeny:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel.add(label2);
        this.hostsDenyList = new TextField(50);
        ((TextComponent)this.hostsDenyList).setText(options.getString("muffin.hostsDeny"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.hostsDenyList, gridBagConstraints);
        panel.add(this.hostsDenyList);
        label2 = new Label("AdminAllow:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel.add(label2);
        this.adminAllowList = new TextField(50);
        ((TextComponent)this.adminAllowList).setText(options.getString("muffin.adminAllow"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.adminAllowList, gridBagConstraints);
        panel.add(this.adminAllowList);
        label2 = new Label("AdminDeny:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        panel.add(label2);
        this.adminDenyList = new TextField(50);
        ((TextComponent)this.adminDenyList).setText(options.getString("muffin.adminDeny"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.adminDenyList, gridBagConstraints);
        panel.add(this.adminDenyList);
        this.add("Center", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2));
        Button button = new Button("Apply");
        button.setActionCommand("doApply");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Save");
        button.setActionCommand("doSave");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button("Close");
        button.setActionCommand("doClose");
        button.addActionListener(this);
        panel2.add(button);
        this.add("South", panel2);
        this.addWindowListener(this);
        configuration.addConfigurationListener(label);
        configuration.addConfigurationListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
    }

    void hideshow() {
        if (this.isShowing()) {
            ((Component)this).setVisible(false);
            return;
        }
        this.show();
    }

    public void configurationChanged(String string) {
        ((TextComponent)this.httpProxyHost).setText(this.options.getString("muffin.httpProxyHost"));
        ((TextComponent)this.httpProxyPort).setText(this.options.getString("muffin.httpProxyPort"));
        ((TextComponent)this.hostsAllowList).setText(this.options.getString("muffin.hostsAllow"));
        ((TextComponent)this.hostsDenyList).setText(this.options.getString("muffin.hostsDeny"));
        ((TextComponent)this.adminAllowList).setText(this.options.getString("muffin.adminAllow"));
        ((TextComponent)this.adminDenyList).setText(this.options.getString("muffin.adminDeny"));
    }

    void sync() {
        this.options.putString("muffin.httpProxyHost", this.httpProxyHost.getText());
        this.options.putString("muffin.httpProxyPort", this.httpProxyPort.getText());
        this.options.putString("muffin.hostsAllow", this.hostsAllowList.getText());
        this.options.putString("muffin.hostsDeny", this.hostsDenyList.getText());
        this.options.putString("muffin.adminAllow", this.adminAllowList.getText());
        this.options.putString("muffin.adminDeny", this.adminDenyList.getText());
        this.options.sync();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("doApply".equals(string)) {
            this.sync();
            return;
        }
        if ("doSave".equals(string)) {
            this.sync();
            UserPrefs userPrefs = this.configs.getUserPrefs();
            userPrefs.putString("muffin.httpProxyHost", this.options.getString("muffin.httpProxyHost"));
            userPrefs.putString("muffin.httpProxyPort", this.options.getString("muffin.httpProxyPort"));
            userPrefs.putString("muffin.hostsAllow", this.options.getString("muffin.hostsAllow"));
            userPrefs.putString("muffin.hostsDeny", this.options.getString("muffin.hostsDeny"));
            userPrefs.putString("muffin.adminAllow", this.options.getString("muffin.adminAllow"));
            userPrefs.putString("muffin.adminDeny", this.options.getString("muffin.adminDeny"));
            userPrefs.save();
            return;
        }
        if ("doClose".equals(string)) {
            ((Component)this).setVisible(false);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

