/*
 * Decompiled with CFR 0.152.
 */
package muffin;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class ThreadsFrame
extends Frame
implements ActionListener,
WindowListener {
    Thread startThread;
    TextArea text;

    ThreadsFrame(Thread thread) {
        super("Muffin: Threads");
        this.startThread = thread;
        ((Component)this).setBackground(Color.lightGray);
        ((Component)this).setFont(new Font("Helvetica", 1, 12));
        this.text = new TextArea();
        this.text.setEditable(false);
        this.text.setFont(new Font("Fixed", 0, 12));
        this.add("Center", this.text);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        Button button = new Button("Update");
        button.setActionCommand("doUpdate");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Close");
        button.setActionCommand("doClose");
        button.addActionListener(this);
        panel.add(button);
        this.add("South", panel);
        this.addWindowListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
        this.show();
        this.update();
    }

    void appendString(String string) {
        this.text.append(string);
    }

    void appendString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > n) {
            stringBuffer.append(string.substring(0, n));
        } else {
            stringBuffer.append(string);
        }
        int n2 = n - stringBuffer.length();
        while (n2-- > 0) {
            stringBuffer.append(" ");
        }
        this.text.append(stringBuffer.toString());
    }

    synchronized void update() {
        this.text.setText("");
        Thread[] threadArray = new Thread[1024];
        int n = Thread.enumerate(threadArray);
        int n2 = 0;
        while (n2 < n) {
            this.appendString(threadArray[n2].getName());
            this.appendString(" -> ");
            this.appendString(threadArray[n2].getThreadGroup().getName());
            this.appendString("\n");
            ++n2;
        }
        if (n == 0) {
            this.text.append("No threads?\n");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("doClose".equals(string)) {
            ((Component)this).setVisible(false);
            return;
        }
        if ("doUpdate".equals(string)) {
            this.update();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

