/*
 * Decompiled with CFR 0.152.
 */
package muffin.filter;

import muffin.ContentFilter;
import muffin.FilterException;
import muffin.Prefs;
import muffin.Reply;
import muffin.ReplyFilter;
import muffin.Request;
import muffin.filter.Decaf;
import muffin.html.Tag;
import muffin.html.Token;
import muffin.io.InputObjectStream;
import muffin.io.OutputObjectStream;

public class DecafFilter
implements ContentFilter,
ReplyFilter {
    Decaf factory;
    Prefs prefs;
    InputObjectStream in;
    OutputObjectStream out;
    Request request;

    DecafFilter(Decaf decaf) {
        this.factory = decaf;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public void filter(Reply reply) throws FilterException {
        String string;
        if (this.prefs.getBoolean("Decaf.noJavaScript") && (string = reply.getContentType()) != null && string.equalsIgnoreCase("application/x-javascript")) {
            this.factory.process("Rejecting " + string + "\n");
            throw new FilterException("Decaf " + string + " rejected");
        }
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        String string = reply.getContentType();
        return string != null && string.startsWith("text/html");
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    public void run() {
        Thread.currentThread().setName("Decaf");
        try {
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = this.prefs.getBoolean("Decaf.noJavaScript");
            boolean bl4 = this.prefs.getBoolean("Decaf.noJava");
            while ((object = this.in.read()) != null) {
                Token token = (Token)object;
                if (token.getType() == -2) {
                    Tag tag = token.createTag();
                    if (bl && tag.is("/script")) {
                        bl = false;
                        continue;
                    }
                    if (bl2 && tag.is("/applet")) {
                        bl2 = false;
                        continue;
                    }
                    if (bl3) {
                        if (tag.is("script")) {
                            bl = true;
                            this.factory.process("Removed <script> from " + this.request.getURL() + "\n");
                        } else if (this.factory.isJavaScriptTag(tag.name())) {
                            String string;
                            StringBuffer stringBuffer = new StringBuffer();
                            int n = 0;
                            while (n < Decaf.javaScriptAttrs.length) {
                                string = tag.remove(Decaf.javaScriptAttrs[n]);
                                if (string != null) {
                                    stringBuffer.append("* <");
                                    stringBuffer.append(tag.name());
                                    stringBuffer.append("> ");
                                    stringBuffer.append(Decaf.javaScriptAttrs[n]);
                                    stringBuffer.append("=\"");
                                    stringBuffer.append(string);
                                    stringBuffer.append("\"\n");
                                }
                                ++n;
                            }
                            if (tag.has("href") && tag.get("href").startsWith("javascript:")) {
                                string = tag.remove("href");
                                stringBuffer.append("* <");
                                stringBuffer.append(tag.name());
                                stringBuffer.append("> ");
                                stringBuffer.append("href=\"");
                                stringBuffer.append(string);
                                stringBuffer.append("\"\n");
                            }
                            if (tag.has("language") && tag.get("language").equalsIgnoreCase("javascript")) {
                                string = tag.remove("language");
                                stringBuffer.append("* <");
                                stringBuffer.append(tag.name());
                                stringBuffer.append("> ");
                                stringBuffer.append("language=\"");
                                stringBuffer.append(string);
                                stringBuffer.append("\"\n");
                            }
                            if (stringBuffer.length() > 0) {
                                this.factory.process("JavaScript removed from " + this.request.getURL() + "\n");
                                this.factory.process(stringBuffer.toString());
                            }
                        }
                    }
                    if (bl4 && tag.is("applet")) {
                        bl2 = true;
                        this.factory.process("Removed <applet> from " + this.request.getURL() + "\n");
                    }
                    if (bl || bl2) continue;
                    token.importTag(tag);
                    this.out.write(token);
                    continue;
                }
                if (bl || bl2) continue;
                this.out.write(token);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

