/*
 * Decompiled with CFR 0.152.
 */
package muffin.html;

import java.util.Enumeration;
import java.util.Hashtable;
import sdsu.util.SimpleTokenizer;
import sdsu.util.TokenCharacters;

public class Tag {
    protected String name = "";
    protected String data;
    private Hashtable attributes;
    private boolean parsed = false;
    private boolean modified = false;

    public Tag(String string, String string2) {
        this.name = string;
        this.data = string2;
    }

    private void parse() {
        this.parsed = true;
        if (this.data == null || this.name.length() <= 0 || this.name.startsWith("<!doctype")) {
            return;
        }
        try {
            TokenCharacters tokenCharacters = new TokenCharacters("", "", '\"', '\"', " \t\r\n");
            tokenCharacters.addQuoteChars('\'', '\'');
            SimpleTokenizer simpleTokenizer = new SimpleTokenizer(this.data, tokenCharacters);
            simpleTokenizer.setEatEscapeChar(false);
            while (simpleTokenizer.hasMoreTokens()) {
                String string = simpleTokenizer.nextToken("=");
                String string2 = simpleTokenizer.separator() == '=' ? simpleTokenizer.nextToken("") : "";
                this.put(string, string2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public String name() {
        return this.name;
    }

    public boolean is(String string) {
        return this.name.equals(string);
    }

    public boolean has(String string) {
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes != null) {
            return this.attributes.containsKey(string);
        }
        return false;
    }

    public String get(String string) {
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes != null) {
            return (String)this.attributes.get(string);
        }
        return null;
    }

    public void put(String string, String string2) {
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable(13);
        }
        this.attributes.put(string.toLowerCase(), string2);
        this.modified = true;
    }

    public String remove(String string) {
        String string2 = null;
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes != null) {
            string2 = (String)this.attributes.remove(string);
            this.modified = true;
        }
        return string2;
    }

    public void rename(String string) {
        this.name = string;
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public Enumeration enumerate() {
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes != null) {
            return this.attributes.keys();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.name);
        if (!this.modified) {
            if (this.data != null) {
                stringBuffer.append(" ");
                stringBuffer.append(this.data);
            }
        } else if (this.attributes != null && !this.attributes.isEmpty()) {
            Enumeration enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append(" ");
                stringBuffer.append(string);
                String string2 = this.get(string);
                if (string2.length() <= 0) continue;
                stringBuffer.append("=");
                boolean bl = string2.indexOf("\"") != -1;
                stringBuffer.append(bl ? "'" : "\"");
                stringBuffer.append(string2);
                stringBuffer.append(bl ? "'" : "\"");
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

