/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.util.Vector;
import sdsu.compare.Comparer;
import sdsu.compare.DoubleComparer;
import sdsu.compare.IntegerComparer;
import sdsu.compare.ReverseOrderComparer;
import sdsu.compare.StringComparer;
import sdsu.compare.StringIgnoreCaseComparer;
import sdsu.util.List;
import sdsu.util.OrderedCollection;
import sdsu.util.SortedCollection;

public class SortedList
extends List
implements SortedCollection {
    protected Comparer order;

    public static SortedList integerSorter() {
        return new SortedList(IntegerComparer.getInstance());
    }

    public static SortedList doubleSorter() {
        return new SortedList(DoubleComparer.getInstance());
    }

    public static SortedList stringSorter() {
        return new SortedList(StringComparer.getInstance());
    }

    public SortedList(Comparer comparer) {
        this(comparer, 10);
    }

    public SortedList(Comparer comparer, int n) {
        super(n);
        this.order = comparer;
    }

    public Comparer getComparer() {
        return this.order;
    }

    public void addElement(Object object) {
        super.insertElementAt(object, this.insertionIndexOf(object));
    }

    public void addElements(SortedCollection sortedCollection) {
        if (this.order.equals(sortedCollection.getComparer())) {
            Object[] objectArray = this.merge(this.toArray(), this.size(), sortedCollection.toArray(), sortedCollection.size());
            this.replaceElements(objectArray);
            return;
        }
        this.addArray(sortedCollection.toArray());
    }

    public void addElements(Vector vector) {
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        this.addArray(objectArray);
    }

    public void addElements(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        this.addArray(objectArray2);
    }

    public final synchronized int indexOf(Object object, int n) {
        Comparer comparer = this.order;
        Object[] objectArray = this.toArray();
        int n2 = this.nearBinarySearch(objectArray, n, this.size() - 1, object);
        while (n2 >= n) {
            if (comparer.greaterThan(object, objectArray[n2])) break;
            --n2;
        }
        if (comparer.equals(object, objectArray[n2 + 1])) {
            return n2 + 1;
        }
        return -1;
    }

    public synchronized OrderedCollection reversed() {
        SortedList sortedList = (SortedList)this.clone();
        sortedList.resort(ReverseOrderComparer.getInstance(this.order));
        return sortedList;
    }

    public synchronized void resort(Comparer comparer) {
        this.order = comparer;
        Object[] objectArray = this.toArray();
        this.sort(objectArray, 0, objectArray.length - 1);
        this.replaceElements(objectArray);
    }

    public synchronized Object clone() {
        SortedList sortedList = (SortedList)super.clone();
        sortedList.order = this.order;
        return sortedList;
    }

    protected void addArray(Object[] objectArray) {
        if (objectArray.length < 10) {
            this.ensureCapacity(objectArray.length + this.size());
            int n = 0;
            while (n < objectArray.length) {
                this.addElement(objectArray[n]);
                ++n;
            }
            return;
        }
        Object[] objectArray2 = this.toArray();
        this.sort(objectArray2, 0, objectArray2.length - 1);
        Object[] objectArray3 = this.merge(objectArray2, objectArray2.length, objectArray, objectArray.length);
        this.replaceElements(objectArray3);
    }

    /*
     * Unable to fully structure code
     */
    protected Object[] merge(Object[] var1_1, int var2_2, Object[] var3_3, int var4_4) {
        block3: {
            var5_5 = 0;
            var6_6 = 0;
            var7_7 = 0;
            var8_8 = this.order;
            var9_9 = new Object[var2_2 + var4_4];
            while (var5_5 < var2_2 && var6_6 < var4_4) {
                var9_9[var7_7++] = var8_8.greaterThan(var1_1[var5_5], var3_3[var6_6]) != false ? var3_3[var6_6++] : var1_1[var5_5++];
            }
            if (var5_5 < var2_2) ** GOTO lbl15
            while (var6_6 < var4_4) {
                var9_9[var7_7++] = var3_3[var6_6++];
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var9_9[var7_7++] = var1_1[var5_5++];
lbl15:
                // 2 sources

                ** while (var5_5 < var2_2)
            }
        }
        return var9_9;
    }

    private int nearBinarySearch(Object[] objectArray, int n, int n2, Object object) {
        Comparer comparer = this.order;
        int n3 = n;
        int n4 = n2;
        while (n4 - n3 > 3) {
            int n5 = (n4 + n3) / 2;
            if (comparer.lessThan(object, objectArray[n5])) {
                n4 = n5 - 1;
                continue;
            }
            if (comparer.greaterThan(object, objectArray[n5])) {
                n3 = n5 + 1;
                continue;
            }
            return n5;
        }
        return n4;
    }

    protected void sort(Object[] objectArray, int n, int n2) {
        Comparer comparer = this.order;
        int n3 = n2 - n + 1;
        while (n3 > 1) {
            n3 = n3 < 5 ? 1 : (5 * n3 - 1) / 11;
            int n4 = n2 - n3;
            while (n4 >= n) {
                Object object = objectArray[n4];
                int n5 = n4 + n3;
                while (n5 <= n2 && comparer.greaterThan(object, objectArray[n5])) {
                    objectArray[n5 - n3] = objectArray[n5];
                    n5 += n3;
                }
                objectArray[n5 - n3] = object;
                --n4;
            }
        }
    }

    protected int insertionIndexOf(Object object) {
        int n = super.size();
        while (n > 0 && this.order.lessThan(object, this.elementAt(n - 1))) {
            --n;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        vector.addElement("one");
        vector.addElement("two");
        vector.addElement("three");
        vector.addElement("four");
        vector.addElement("five");
        SortedList sortedList = new SortedList(StringIgnoreCaseComparer.getInstance());
        sortedList.addElements(vector);
        System.out.println(sortedList.toString());
        Object[] objectArray = new Object[]{"apple", "orange", "pear", "banana", "guava"};
        sortedList.removeAllElements();
        sortedList.addElements(objectArray);
        System.out.println(sortedList.toString());
    }
}

