/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Vector;
import sdsu.util.SimpleTokenizer;
import sdsu.util.Stringizer;
import sdsu.util.TokenCharacters;

public class Table
implements Cloneable {
    private static final String NEW_LINE = "\n";
    private char rowSeparatorChar = (char)59;
    private char columnSeparatorChar = (char)44;
    Object[][] tableElements;
    private int numberOfRows;
    private int numberOfColumns;
    private int capacityIncrement = 10;
    private TokenCharacters parseTable = new TokenCharacters(String.valueOf(String.valueOf(this.rowSeparatorChar)) + String.valueOf(this.columnSeparatorChar));

    public Table() {
        this(0, 0);
    }

    public Table(int n, int n2) {
        this.numberOfRows = n;
        this.numberOfColumns = n2;
        this.tableElements = new Object[this.numberOfRows + this.capacityIncrement][this.numberOfColumns + this.capacityIncrement];
    }

    public static Table fromRowVector(Vector vector) {
        Table table = new Table(1, vector.size());
        int n = 0;
        while (n < vector.size()) {
            table.tableElements[0][n] = vector.elementAt(n);
            ++n;
        }
        return table;
    }

    public static Table fromColumnVector(Vector vector) {
        Table table = new Table(vector.size(), 1);
        int n = 0;
        while (n < vector.size()) {
            table.tableElements[n][0] = vector.elementAt(n);
            ++n;
        }
        return table;
    }

    public void setTokenCharacters(TokenCharacters tokenCharacters) {
        this.parseTable = tokenCharacters;
        this.upDateParseTable();
    }

    public void setRowSeparatorChar(char c) {
        this.rowSeparatorChar = c;
        this.upDateParseTable();
    }

    public void setColumnSeparatorChar(char c) {
        this.columnSeparatorChar = c;
        this.upDateParseTable();
    }

    public synchronized Point indexOf(Object object) {
        int n = 0;
        while (n < this.numberOfRows) {
            int n2 = 0;
            while (n2 < this.numberOfColumns) {
                if (object.equals(this.tableElements[n][n2])) {
                    return new Point(n, n2);
                }
                ++n2;
            }
            ++n;
        }
        return new Point(-1, -1);
    }

    public boolean contains(Object object) {
        return this.indexOf((Object)object).x != -1;
    }

    public synchronized Object clone() {
        try {
            Table table = (Table)super.clone();
            int n = this.tableElements.length;
            int n2 = this.tableElements[0].length;
            table.tableElements = new Object[n][n2];
            int n3 = 0;
            while (n3 < this.numberOfRows) {
                System.arraycopy(this.tableElements[n3], 0, table.tableElements[n3], 0, this.numberOfColumns);
                ++n3;
            }
            return table;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized Object elementAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        this.checkBounds(n, n2);
        return this.tableElements[n][n2];
    }

    public synchronized Vector rowAt(int n) throws ArrayIndexOutOfBoundsException {
        this.checkBounds(n, 0);
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        while (n2 < this.numberOfColumns) {
            vector.addElement(this.tableElements[n][n2]);
            ++n2;
        }
        return vector;
    }

    public synchronized Vector columnAt(int n) throws ArrayIndexOutOfBoundsException {
        this.checkBounds(0, n);
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        while (n2 < this.numberOfRows()) {
            vector.addElement(this.tableElements[n2][n]);
            ++n2;
        }
        return vector;
    }

    public synchronized Table columnsAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        Table table = new Table(this.numberOfRows, 0);
        int n3 = n;
        while (n3 <= n2) {
            table.addColumn(this.columnAt(n3));
            ++n3;
        }
        return table;
    }

    public synchronized Table columnsAt(Object object, int n) throws ArrayIndexOutOfBoundsException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numberOfColumns) {
            if (this.tableElements[n][n3].equals(object)) {
                ++n2;
            }
            ++n3;
        }
        Table table = new Table(0, 0);
        table.insureCapacity(this.numberOfRows, n2);
        int n4 = 0;
        while (n4 < this.numberOfColumns) {
            if (this.tableElements[n][n4].equals(object)) {
                table.addColumn(this.columnAt(n4));
            }
            ++n4;
        }
        return table;
    }

    public synchronized Table rowsAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        Table table = new Table(n2 - n + 1, this.numberOfColumns);
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            System.arraycopy(this.tableElements[n4], 0, table.tableElements[n3++], 0, this.numberOfColumns);
            ++n4;
        }
        return table;
    }

    public synchronized Table rowsAt(Object object, int n) throws ArrayIndexOutOfBoundsException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numberOfRows) {
            if (this.tableElements[n3][n].equals(object)) {
                ++n2;
            }
            ++n3;
        }
        Table table = new Table(n2, this.numberOfColumns);
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.numberOfRows) {
            if (this.tableElements[n5][n].equals(object)) {
                System.arraycopy(this.tableElements[n5], 0, table.tableElements[n4++], 0, this.numberOfColumns);
            }
            ++n5;
        }
        return table;
    }

    public synchronized Enumeration elements() {
        Vector<Object> vector = new Vector<Object>(this.numberOfColumns * this.numberOfRows);
        int n = 0;
        while (n < this.numberOfRows) {
            int n2 = 0;
            while (n2 < this.numberOfColumns) {
                if (this.tableElements[n][n2] != null) {
                    vector.addElement(this.tableElements[n][n2]);
                }
                ++n2;
            }
            ++n;
        }
        return vector.elements();
    }

    public synchronized void setElementAt(Object object, int n, int n2) throws ArrayIndexOutOfBoundsException {
        this.checkBounds(n, n2);
        this.tableElements[n][n2] = object;
    }

    public synchronized void addRow(Vector vector) {
        Table table = Table.fromRowVector(vector);
        this.addRows(table);
    }

    public synchronized void addRows(Table table) {
        this.insertRowsAt(table, this.numberOfRows);
    }

    public synchronized void insertRowsAt(Table table, int n) throws ArrayIndexOutOfBoundsException {
        int n2;
        if (n > this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException("inserting rows beyond end of the table");
        }
        int n3 = Math.max(table.numberOfColumns() - this.numberOfColumns, 0);
        int n4 = table.numberOfRows();
        this.insureCapacity(n4, n3);
        if (n < this.numberOfRows) {
            System.arraycopy(this.tableElements, n, this.tableElements, n + n4, this.numberOfRows - n);
            n2 = this.tableElements[0].length;
            int n5 = n;
            while (n5 < n + n4) {
                this.tableElements[n5] = new Object[n2];
                ++n5;
            }
        }
        n2 = 0;
        while (n2 < table.numberOfRows()) {
            System.arraycopy(table.tableElements[n2], 0, this.tableElements[n2 + n], 0, table.numberOfColumns());
            ++n2;
        }
        this.numberOfColumns += n3;
        this.numberOfRows += n4;
    }

    public synchronized void addColumn(Vector vector) {
        Table table = Table.fromColumnVector(vector);
        this.addColumns(table);
    }

    public synchronized void addColumns(Table table) {
        this.insertColumnsAt(table, this.numberOfColumns);
    }

    public synchronized void insertColumnsAt(Table table, int n) throws ArrayIndexOutOfBoundsException {
        int n2;
        if (n > this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException("inserting columns beyond end of the table");
        }
        int n3 = Math.max(table.numberOfRows() - this.numberOfRows, 0);
        int n4 = table.numberOfColumns();
        this.insureCapacity(n3, n4);
        if (n < this.numberOfColumns) {
            n2 = 0;
            while (n2 < this.numberOfRows) {
                System.arraycopy(this.tableElements[n2], n, this.tableElements[n2], n + n4, this.numberOfColumns - n);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.numberOfRows + n3) {
            int n5 = 0;
            while (n5 < n4) {
                this.tableElements[n2][n5 + n] = table.tableElements[n2][n5];
                ++n5;
            }
            ++n2;
        }
        this.numberOfColumns += n4;
        this.numberOfRows += n3;
    }

    public synchronized void removeRowAt(int n) throws ArrayIndexOutOfBoundsException {
        this.removeRowsAt(n, n);
    }

    public synchronized void removeRowsAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 < n || n < 0 || n2 < 0 || n2 > this.numberOfRows || n > this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 < this.numberOfRows) {
            System.arraycopy(this.tableElements, n2 + 1, this.tableElements, n, this.numberOfRows - n2);
        }
        this.numberOfRows = this.numberOfRows - (n2 - n) - 1;
    }

    public synchronized void removeRowsAt(Object object, int n) throws ArrayIndexOutOfBoundsException, NullPointerException {
        int n2 = 0;
        while (n2 < this.numberOfRows) {
            if (object.equals(this.elementAt(n2, n))) {
                this.removeRowsAt(n2, n2);
            }
            ++n2;
        }
    }

    public synchronized void removeColumnAt(int n) throws ArrayIndexOutOfBoundsException {
        this.removeColumnsAt(n, n);
    }

    public synchronized void removeColumnsAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 < n || n < 0 || n2 < 0 || n2 > this.numberOfColumns || n > this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 < this.numberOfColumns) {
            int n3 = 0;
            while (n3 < this.numberOfRows) {
                System.arraycopy(this.tableElements[n3], n2 + 1, this.tableElements[n3], n, this.numberOfColumns - n2);
                ++n3;
            }
        }
        this.numberOfColumns = this.numberOfColumns - (n2 - n) - 1;
    }

    public synchronized void removeColumnsAt(Object object, int n) throws ArrayIndexOutOfBoundsException, NullPointerException {
        int n2 = 0;
        while (n2 < this.numberOfColumns) {
            if (object.equals(this.elementAt(n, n2))) {
                this.removeColumnsAt(n2, n2);
            }
            ++n2;
        }
    }

    public int size() {
        return this.numberOfRows * this.numberOfColumns;
    }

    public int numberOfColumns() {
        return this.numberOfColumns;
    }

    public int numberOfRows() {
        return this.numberOfRows;
    }

    public String toString() {
        return this.toString(null);
    }

    public synchronized String toString(String string) {
        Stringizer stringizer = new Stringizer(this.parseTable);
        stringizer.setHeader(string);
        String string2 = String.valueOf(String.valueOf(this.rowSeparatorChar)) + NEW_LINE;
        int n = 0;
        while (n < this.numberOfRows) {
            int n2 = 0;
            while (n2 < this.numberOfColumns - 1) {
                stringizer.appendToken((Object)(this.tableElements[n][n2] == null ? "" : this.tableElements[n][n2].toString()), this.columnSeparatorChar);
                ++n2;
            }
            int n3 = this.numberOfColumns - 1;
            stringizer.appendToken((Object)(this.tableElements[n][n3] == null ? "" : this.tableElements[n][n3].toString()), string2);
            ++n;
        }
        return stringizer.toString();
    }

    public synchronized void save(OutputStream outputStream, String string) {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println(this.toString(string));
        printStream.flush();
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        SimpleTokenizer simpleTokenizer = new SimpleTokenizer(inputStream, this.parseTable);
        Vector<String> vector = new Vector<String>();
        while (simpleTokenizer.hasMoreTokens()) {
            vector.addElement(simpleTokenizer.nextToken());
            if (simpleTokenizer.separator() != this.rowSeparatorChar) continue;
            this.addRow(vector);
            vector.removeAllElements();
        }
        if (vector.size() > 0) {
            this.addRow(vector);
        }
    }

    public synchronized void fromString(String string) throws IOException {
        this.load(new StringBufferInputStream(string));
    }

    private int surplusRows() {
        return this.tableElements.length - this.numberOfRows;
    }

    private int surplusColumns() {
        return this.tableElements[0].length - this.numberOfColumns;
    }

    private String elementToString(int n, int n2) {
        if (this.tableElements[n][n2] == null) {
            return "";
        }
        return this.tableElements[n][n2].toString();
    }

    private void insureCapacity(int n, int n2) {
        if (n <= this.tableElements.length - this.numberOfRows && n2 <= this.tableElements[0].length - this.numberOfColumns) {
            return;
        }
        int n3 = n > this.tableElements.length - this.numberOfRows ? this.numberOfRows + this.capacityIncrement + n : this.tableElements.length;
        int n4 = n2 > this.tableElements[0].length - this.numberOfColumns ? this.numberOfColumns + this.capacityIncrement + n2 : this.tableElements[0].length;
        this.growCapacityTo(n3, n4);
    }

    private void growCapacityTo(int n, int n2) {
        Object[][] objectArray = new Object[n][n2];
        int n3 = 0;
        while (n3 < this.numberOfRows) {
            System.arraycopy(this.tableElements[n3], 0, objectArray[n3], 0, this.numberOfColumns);
            ++n3;
        }
        this.tableElements = objectArray;
    }

    private void checkBounds(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n >= this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException("Row index: " + n + " >= " + this.numberOfRows);
        }
        if (n2 >= this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException("Column index: " + n2 + " >= " + this.numberOfColumns);
        }
    }

    private void upDateParseTable() {
        this.parseTable.setSeparatorChars(String.valueOf(String.valueOf(this.columnSeparatorChar)) + String.valueOf(this.rowSeparatorChar));
    }
}

