/* FilterFactory.java */

/* 
 * Copyright (C) 1996-98 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

/**
 * Factory implemented by all filters.  This class is used to
 * maintain filter preferences and create filters using
 * the createFilter factory method.
 * 
 * @author Mark Boyns
 */
public interface FilterFactory
{
    /**
     * Set the manager of this factory.  The manager is normally
     * used to save preferences in the main preferences file.
     */
    public void setManager (FilterManager m);

    /**
     * Set filter preferences.  This method is called by the
     * filter manager.
     */
    public void setPrefs (Prefs p);

    /**
     * Return filter preferences.
     */
    public Prefs getPrefs ();

    /**
     * View filter preferences.  This can be used to create
     * a GUI interface to modify preferences.
     */
    public void viewPrefs ();

    /**
     * Factory method which returns a Filter.
     */
    public Filter createFilter ();

    /**
     * Shutdown the factory.  Method called when filter
     * factory is disabled.
     */
    public void shutdown ();
}
