/* HttpRelay.java */

/* 
 * Copyright (C) 1996-98 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * Generic HTTP interface.
 *
 * @author Mark Boyns
 */
class HttpRelay extends Connection
{
    HttpRelay ()
    {
    }
    
    /**
     * Create a HttpRelay.
     *
     * @param host hostname
     * @param port port number
     */
    HttpRelay (String host, int port) throws java.io.IOException
    {
	super (host, port);
    }

    /**
     * Read a reply.
     */
    Reply read () throws java.io.IOException
    {
	Reply reply = new Reply ();
	reply.read (in);
	return reply;
    }
    
    /**
     * Write a request.
     */
    void write (Request request) throws java.io.IOException
    {
	request.write (out);
    }
}
