/* SecretaryFilter.java */

/* 
 * Copyright (C) 1997 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package muffin.filter;

import muffin.*;
import muffin.html.*;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.util.Enumeration;

public class SecretaryFilter implements ContentFilter
{
  Secretary factory;
  Prefs prefs;
  InputStream in = null;
  OutputStream out = null;
  Request request = null;

  public SecretaryFilter (Secretary factory)
  {
    this.factory = factory;
  }
    
  public void setPrefs (Prefs prefs)
  {
    this.prefs = prefs;
  }

  public boolean needsFiltration (Request request, Reply reply)
  {
    this.request = request;
    String s = reply.getHeaderField ("Content-type");
    return s != null && s.startsWith ("text/html");
  }
    
  public void setInputStream (InputStream in)
  {
    this.in = in;
  }

  public void setOutputStream (OutputStream out)
  {
    this.out = out;
  }

  public void run ()
  {
    try
      {
	HtmlTokenizer html = new HtmlTokenizer (in);
	int token;
	String s;
	boolean inform = false;
	String selectName = null;

	while ((token = html.getToken ()) != HtmlTokenizer.TT_EOF)
	  {
	    if (token == HtmlTokenizer.TT_TAG)
	      {
		Tag tag = html.getTag ();
		if (tag.is ("form"))
		  {
		    inform = true;
		  }
		else if (tag.is ("/form"))
		  {
		    inform = false;
		  }
		else if (tag.is ("select"))
		  {
		    if (tag.has ("name"))
		      {
			selectName = tag.get ("name").toLowerCase ();
		      }
		  }
		else if (tag.is ("/select"))
		  {
		    selectName = null;
		  }
		/* <input type=text name=xxx> */
		else if (inform && tag.is ("input")
			 && tag.has ("type")
			 && tag.get ("type").equals ("text")
			 && tag.has ("name"))
		  {
		    String name = tag.get ("name").toLowerCase ();
		    if (factory.Lockup.containsKey (name))
		      {
			String Attribute = (String) factory.Lockup.get(name);
			tag.put ("value", (String) factory.Values.get (Attribute));
		      }
		  }
		/* <option value=XXX> */
		else if (inform && tag.is ("option")
			 && selectName != null
			 && factory.Lockup.containsKey (selectName)
			 && tag.has ("value"))
		  {
		    if (tag.has ("selected"))
		      {
			tag.remove ("selected");
		      }
			
		    String value = (String) tag.get ("value");
		    String Attribute = (String) factory.Lockup.get(selectName);
		    if (factory.Values.get (Attribute).equals (tag.get ("value")))
		      {
			tag.put ("selected", "");
		      }
		  }
		html.writeTag (tag, out);
	      }
	    else
	      {
		html.writeToken (out);
	      }
	  }
	out.flush ();
	out.close ();
      }
    catch (Exception e)
      {
	e.printStackTrace ();
      }
  }
}

