/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;

public class RETest {
    RETest() {
    }

    public static void main(String[] stringArray) throws REException {
        System.out.println("gnu.regexp package Version 1.00");
        int n = 1;
        if (stringArray.length == 3) {
            n = Integer.parseInt(stringArray[2]);
        }
        if (stringArray.length < 2) {
            System.out.println("usage: java RETest regExp inputString [numRepeats]");
            System.exit(1);
        }
        RE rE = null;
        long l = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < n) {
            rE = new RE(stringArray[0]);
            ++n2;
        }
        long l2 = System.currentTimeMillis();
        if (n > 1) {
            System.out.println("Compiling " + n + " times took " + (l2 - l) + " ms");
            System.out.println("Average compile time: " + (l2 - l) / (long)n + " ms");
        }
        System.out.println("isMatch: " + rE.isMatch(stringArray[1]));
        REMatch[] rEMatchArray = rE.getAllMatches(stringArray[1]);
        System.out.println("Total possible matches found: " + rEMatchArray.length);
        REMatch rEMatch = null;
        l = System.currentTimeMillis();
        int n3 = 0;
        while (n3 < n) {
            rEMatch = rE.getMatch(stringArray[1]);
            ++n3;
        }
        l2 = System.currentTimeMillis();
        if (n > 1) {
            System.out.println("Matching " + n + " times took " + (l2 - l) + " ms");
            System.out.println("Average match time: " + (l2 - l) / (long)n + " ms");
        }
        if (rEMatch == null) {
            System.out.println("Expression did not find a match.");
            return;
        }
        System.out.println("Match found from position " + rEMatch.getStartIndex() + " to position " + rEMatch.getEndIndex());
        System.out.println("Match was: '" + rEMatch + "'");
        int n4 = 1;
        while (n4 <= rE.getNumSubs()) {
            System.out.println("Subexpression #" + n4 + ": from position " + rEMatch.getSubStartIndex(n4) + " to position " + rEMatch.getSubEndIndex(n4));
            System.out.println(rEMatch.substituteInto("The subexpression matched this text: '$" + n4 + "'"));
            ++n4;
        }
    }
}

