/*
 * Decompiled with CFR 0.152.
 */
package org.doit.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;
import org.doit.io.OutputObjectStream;

public class InputObjectStream {
    protected final int maxObjects = 64;
    protected Vector objects = new Vector();
    protected Thread inputThread;
    protected Thread outputThread;
    protected boolean closed = true;
    protected boolean connected = false;

    public InputObjectStream(OutputObjectStream outputObjectStream) throws IOException {
        this.connect(outputObjectStream);
    }

    public InputObjectStream() {
    }

    public void connect(OutputObjectStream outputObjectStream) throws IOException {
        if (this.connected) {
            throw new IOException("Input side already connected");
        }
        outputObjectStream.connect(this);
        this.connected = true;
    }

    public synchronized Object read() throws IOException {
        this.inputThread = Thread.currentThread();
        while (this.objects.isEmpty()) {
            if (this.closed) {
                return null;
            }
            if (this.outputThread != null && !this.outputThread.isAlive()) {
                throw new IOException("Output side not connected");
            }
            this.notify();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        Object e = this.objects.firstElement();
        try {
            this.objects.removeElementAt(0);
        }
        catch (Exception exception) {}
        return e;
    }

    public synchronized void unread(Object object) throws IOException {
        this.objects.insertElementAt(object, 0);
    }

    public void close() throws IOException {
        this.objects.removeAllElements();
    }

    protected synchronized void append(Object object) throws IOException {
        this.outputThread = Thread.currentThread();
        while (this.objects.size() == 64) {
            if (this.inputThread != null && !this.inputThread.isAlive()) {
                throw new IOException("Input side not connected");
            }
            this.notify();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        this.objects.addElement(object);
    }

    protected synchronized void done() {
        this.closed = true;
        this.notify();
    }
}

