/* ForwardedForFilter.java */

/* 
 * Copyright (C) 1996-98 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.doit.muffin.filter;

import org.doit.muffin.*;

public class ForwardedForFilter implements RequestFilter
{
    Prefs prefs;
    ForwardedFor factory;

    ForwardedForFilter (ForwardedFor factory)
    {
	this.factory = factory;
    }
    
    public void setPrefs (Prefs prefs)
    {
	this.prefs = prefs;
    }

    public void filter (Request request) throws FilterException
    {
	String addr = request.getClient ().getInetAddress ().getHostAddress ();
	if (request.containsHeaderField ("X-Forwarded-For"))
	{
	    request.appendHeaderField ("X-Forwarded-For", ", " + addr);
	}
	else
	{
	    request.setHeaderField ("X-Forwarded-For", addr);
	}
    }
}
