/*
 * Decompiled with CFR 0.152.
 */
package org.doit.html;

import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.util.Enumeration;
import java.util.Hashtable;
import org.doit.html.NoValue;
import sdsu.util.SimpleTokenizer;
import sdsu.util.TokenCharacters;

public class Tag {
    protected String name = "";
    protected String data = null;
    private Hashtable attributes = null;
    private boolean parsed = false;
    private boolean modified = false;

    private void parse() {
        this.parsed = true;
        if (this.data == null || this.name.length() <= 0 || this.name.startsWith("<!doctype")) {
            return;
        }
        try {
            boolean bl = this.modified;
            TokenCharacters tokenCharacters = new TokenCharacters("", "", '\"', '\"', " \t\r\n");
            tokenCharacters.addQuoteChars('\'', '\'');
            SimpleTokenizer simpleTokenizer = new SimpleTokenizer(this.data, tokenCharacters);
            simpleTokenizer.setEatEscapeChar(false);
            while (simpleTokenizer.hasMoreTokens()) {
                String string = simpleTokenizer.nextToken("=");
                if (simpleTokenizer.separator() == '=') {
                    String string2 = simpleTokenizer.nextToken("");
                    this.put(string, string2);
                    continue;
                }
                this.put(string, null);
            }
            this.modified = bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String name() {
        return this.name;
    }

    public boolean is(String string) {
        return this.name.equals(string);
    }

    public boolean has(String string) {
        if (!this.parsed) {
            this.parse();
        }
        return this.attributes != null ? this.attributes.containsKey(string) : false;
    }

    public String get(String string) {
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes == null) {
            return null;
        }
        Object v = this.attributes.get(string);
        if (v instanceof String) {
            return (String)v;
        }
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public void put(String string, String string2) {
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable(13);
        }
        this.attributes.put(string.toLowerCase(), string2 == null ? new NoValue() : string2);
        this.modified = true;
    }

    public String remove(String string) {
        String string2 = null;
        if (!this.parsed) {
            this.parse();
        }
        if (this.attributes != null) {
            Object v = this.attributes.remove(string);
            this.modified = true;
            if (v != null) {
                string2 = v.toString();
            }
        }
        return string2;
    }

    public void rename(String string) {
        this.name = string;
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public Enumeration enumerate() {
        if (!this.parsed) {
            this.parse();
        }
        return this.attributes != null ? this.attributes.keys() : null;
    }

    public int attributeCount() {
        if (!this.parsed) {
            this.parse();
        }
        return this.attributes != null ? this.attributes.size() : 0;
    }

    public boolean matches(RE rE) {
        REMatch rEMatch = rE.getMatch(this.name);
        return rEMatch != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(this.name);
        if (!this.modified) {
            if (this.data != null) {
                stringBuffer.append(' ');
                stringBuffer.append(this.data);
            }
        } else if (this.attributes != null && !this.attributes.isEmpty()) {
            Enumeration enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append(' ');
                stringBuffer.append(string);
                String string2 = this.get(string);
                if (!(string2 instanceof String)) continue;
                String string3 = string2;
                stringBuffer.append('=');
                boolean bl = string3.indexOf(34) != -1;
                stringBuffer.append(bl ? (char)'\'' : '\"');
                stringBuffer.append(string3);
                stringBuffer.append(bl ? (char)'\'' : '\"');
            }
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public Tag(String string, String string2) {
        this.name = string;
        this.data = string2;
    }
}

