/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.Choice;
import java.awt.Label;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.doit.muffin.ConfFileFilter;
import org.doit.muffin.ConfigurationFrame;
import org.doit.muffin.ConfigurationListener;
import org.doit.muffin.LocalFile;
import org.doit.muffin.Prefs;
import org.doit.muffin.UserFile;
import org.doit.muffin.UserPrefs;

class Configuration
extends Prefs {
    String autoConfigFile = "autoconfig";
    String currentConfig = null;
    String defaultConfig = null;
    Vector autoConfigPatterns = new Vector();
    Vector autoConfigNames = new Vector();
    ConfigurationFrame frame = null;
    Vector configurationListeners = new Vector();

    void setAutoConfigFile(String string) {
        this.autoConfigFile = string;
    }

    void addConfigurationListener(Object object) {
        this.configurationListeners.addElement(object);
        this.updateConfigurationListener(object);
    }

    synchronized void updateConfigurationListener(Object object) {
        if (object instanceof Label) {
            Label label = (Label)object;
            label.setText("Current Configuration: " + this.getCurrent());
            label.doLayout();
        } else if (object instanceof Choice) {
            Choice choice = (Choice)object;
            choice.select(this.getCurrent());
        } else if (object instanceof ConfigurationListener) {
            ConfigurationListener configurationListener = (ConfigurationListener)object;
            configurationListener.configurationChanged(this.getCurrent());
        }
    }

    void updateConfigurationListeners() {
        int n = 0;
        while (n < this.configurationListeners.size()) {
            Object e = this.configurationListeners.elementAt(n);
            this.updateConfigurationListener(e);
            ++n;
        }
    }

    void setDefault(String string) {
        this.defaultConfig = string;
    }

    String getDefault() {
        return this.defaultConfig;
    }

    synchronized void setCurrent(String string) {
        if (!string.equals(this.currentConfig)) {
            this.currentConfig = string;
            if (!this.exists(this.currentConfig)) {
                this.createConfig(this.currentConfig);
            }
            this.updateConfigurationListeners();
        }
    }

    String getCurrent() {
        return this.currentConfig;
    }

    void createConfig(String string) {
        if (!string.endsWith(".conf")) {
            string = string + ".conf";
        }
        System.out.println("Creating new configuration: " + string);
        UserPrefs userPrefs = new UserPrefs(string);
        this.put(string, userPrefs);
        this.updateConfigurationListeners();
    }

    UserPrefs getUserPrefs() {
        return this.getUserPrefs(this.currentConfig);
    }

    UserPrefs getUserPrefs(String string) {
        UserPrefs userPrefs = (UserPrefs)this.get(string);
        userPrefs.load();
        return userPrefs;
    }

    String autoConfig(String string) {
        int n = 0;
        while (n < this.autoConfigPatterns.size()) {
            RE rE = (RE)this.autoConfigPatterns.elementAt(n);
            if (rE.getMatch(string) != null) {
                return (String)this.autoConfigNames.elementAt(n);
            }
            ++n;
        }
        return this.defaultConfig;
    }

    UserFile getAutoConfigFile() {
        return this.getUserFile(this.autoConfigFile);
    }

    UserFile getUserConfigFile(String string) {
        return this.getUserFile(string);
    }

    boolean deleteUserConfigFile(String string) {
        UserFile userFile = this.getUserConfigFile(string);
        if (userFile instanceof LocalFile) {
            return ((LocalFile)userFile).delete();
        }
        return false;
    }

    boolean delete(String string) {
        if (string.equals(this.getDefault())) {
            System.out.println("Can't delete default configuration");
            return false;
        }
        this.remove(string);
        if (string.equals(this.getCurrent())) {
            this.setCurrent(this.getDefault());
        }
        return true;
    }

    void load(Reader reader) {
        this.autoConfigPatterns = new Vector();
        this.autoConfigNames = new Vector();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                String string3;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                try {
                    string3 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                RE rE = new RE(string3);
                this.autoConfigPatterns.addElement(rE);
                this.autoConfigNames.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (REException rEException) {
            System.out.println(rEException);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    /*
     * Loose catch block
     */
    void load() {
        block14: {
            InputStream inputStream = null;
            Object object2222 = this.getAutoConfigFile();
            inputStream = object2222.getInputStream();
            this.load(new InputStreamReader(inputStream));
            System.out.println("Using " + object2222.getName());
            Object var3_8 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block14;
            }
            catch (IOException object2222) {}
            break block14;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    Object var3_9 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                    Object var3_10 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_11 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    void reload() {
        this.load();
        if (this.frame != null) {
            this.frame.loadAutoConfigFile();
        }
    }

    void rescan() {
        this.clear();
        this.scan();
    }

    void scan() {
        File file = new File(this.getUserDirectory());
        if (!file.exists()) {
            return;
        }
        String[] stringArray = file.list(new ConfFileFilter());
        int n = 0;
        while (n < stringArray.length) {
            UserPrefs userPrefs = new UserPrefs(stringArray[n]);
            this.put(stringArray[n], userPrefs);
            ++n;
        }
    }

    void createFrame() {
        if (this.frame == null) {
            this.frame = new ConfigurationFrame(this);
        }
        this.frame.show();
    }

    Configuration() {
    }
}

