/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.doit.muffin.MuffinResolver;

class Connection {
    Socket socket = null;
    InputStream in = null;
    OutputStream out = null;

    InputStream getInputStream() {
        return this.in;
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                System.out.println("Connection: " + iOException);
            }
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public String toString() {
        return this.getInetAddress().getHostAddress() + ":" + this.getPort();
    }

    public void setTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }

    Connection(Socket socket) throws IOException {
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
    }

    Connection(String string, int n) throws IOException {
        this(new Socket(MuffinResolver.getByName(string), n));
    }

    Connection() {
    }
}

