/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;
import org.doit.muffin.Main;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;

public class LogFile {
    private static SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss", Locale.US);
    private static String zoneString;
    private String filename = null;
    private long maxLogFileSize;
    private int maxLogFileHistory;

    public void setLogFile(String string) {
        this.filename = string;
    }

    private static String generateZoneString() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(15) + calendar.get(16);
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            stringBuffer.append("-");
            n = -n;
        }
        int n2 = n / 3600000;
        int n3 = n % 3600000 / 60000;
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        return stringBuffer.toString();
    }

    private void gzip(File file) {
        File file2 = new File(file.getAbsolutePath() + ".gz");
        byte[] byArray = new byte[8192];
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)new FileOutputStream(file2), byArray.length);
            while ((n = fileInputStream.read(byArray)) >= 0) {
                gZIPOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            gZIPOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void rotate(int n) {
        File file;
        int n2 = n - 2;
        while (n2 >= 1) {
            file = new File(this.filename + "." + n2 + ".gz");
            if (file.exists()) {
                file.renameTo(new File(this.filename + "." + (n2 + 1) + ".gz"));
            }
            --n2;
        }
        file = new File(this.filename + ".0");
        if (file.exists()) {
            this.gzip(file);
            file = new File(this.filename + ".0.gz");
            file.renameTo(new File(this.filename + ".1.gz"));
        }
        file = new File(this.filename);
        file.renameTo(new File(this.filename + ".0"));
    }

    public synchronized void log(Request request, Reply reply) {
        Object object;
        Object object2;
        int n;
        Date date = new Date();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(request.getClient().getInetAddress().getHostAddress());
        stringBuffer.append(" - - ");
        stringBuffer.append("[");
        stringBuffer.append(format.format(date));
        stringBuffer.append(" ");
        stringBuffer.append(zoneString);
        stringBuffer.append("] \"");
        stringBuffer.append(request.getRequest());
        stringBuffer.append("\" ");
        stringBuffer.append(reply.getStatusCode());
        stringBuffer.append(" ");
        try {
            n = Integer.parseInt(reply.getHeaderField("Content-length"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        stringBuffer.append(n);
        stringBuffer.append("\n");
        if (!Main.getOptions().getBoolean("muffin.dontLogFilters")) {
            object2 = request.getLogHeaders();
            while (object2 != null && object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                stringBuffer.append("[");
                stringBuffer.append((String)object);
                stringBuffer.append("]\n");
                Enumeration enumeration = request.getLogEntries((String)object);
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append("* ");
                    stringBuffer.append(enumeration.nextElement().toString());
                    stringBuffer.append("\n");
                }
            }
        }
        try {
            object2 = new File(this.filename);
            if (((File)object2).length() > this.maxLogFileSize) {
                this.rotate(this.maxLogFileHistory);
            }
            object = new FileOutputStream(this.filename, true);
            ((FileOutputStream)object).write(stringBuffer.toString().getBytes());
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public LogFile(String string) {
        this.setLogFile(string);
        this.maxLogFileSize = Main.getOptions().getLong("muffin.maxLogFileSize");
        this.maxLogFileHistory = Main.getOptions().getInteger("muffin.maxLogFileHistory");
    }

    static {
        format.setTimeZone(TimeZone.getDefault());
        zoneString = LogFile.generateZoneString();
    }
}

