/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.doit.muffin.LocalFile;
import org.doit.muffin.URLFile;
import org.doit.muffin.UserFile;
import sdsu.compare.StringIgnoreCaseComparer;
import sdsu.util.SortedList;

public class Prefs
extends Hashtable {
    private static String userDirectory = "Muffin";
    private static String userHomeProperty;
    boolean allowOverride = true;

    public void setUserDirectory(String string) {
        userDirectory = string;
    }

    public String getUserDirectory() {
        if (userDirectory.indexOf(System.getProperty("file.separator")) != -1) {
            return userDirectory;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty(userHomeProperty));
        if (userDirectory != null && userDirectory.length() > 0) {
            stringBuffer.append(System.getProperty("file.separator"));
            stringBuffer.append(userDirectory);
        }
        return stringBuffer.toString();
    }

    public void checkDirectory(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("Creating " + string);
            if (!file.mkdirs()) {
                System.out.println("Can't create " + string);
            }
        }
    }

    public void checkUserDirectory() {
        this.checkDirectory(this.getUserDirectory());
    }

    public UserFile getUserFile(String string) {
        UserFile userFile = null;
        try {
            userFile = new URLFile(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            userFile = string.indexOf(System.getProperty("file.separator")) != -1 ? new LocalFile(string) : new LocalFile(this.getUserDirectory() + System.getProperty("file.separator") + string);
        }
        return userFile;
    }

    public boolean exists(Object object) {
        return this.containsKey(object);
    }

    public synchronized Object put(Object object, Object object2) {
        if (this.allowOverride || !this.exists(object)) {
            return super.put(object, object2);
        }
        return null;
    }

    public void setOverride(boolean bl) {
        this.allowOverride = bl;
    }

    public boolean getOverride() {
        return this.allowOverride;
    }

    public void putString(String string, String string2) {
        this.put(string, string2);
    }

    public void putBoolean(String string, boolean bl) {
        this.put(string, bl ? "true" : "false");
    }

    public void putInteger(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public String getString(String string) {
        return (String)this.get(string);
    }

    public boolean getBoolean(String string) {
        String string2 = this.getString(string);
        if (string2 == null) {
            return false;
        }
        return "true".equalsIgnoreCase(string2);
    }

    public int getInteger(String string) {
        int n;
        try {
            n = Integer.parseInt(this.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    public long getLong(String string) {
        long l;
        try {
            l = Long.parseLong(this.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            l = -1L;
        }
        return l;
    }

    String toHexString(int n, int n2) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public void putColor(String string, Color color) {
        this.putString(string, "#" + this.toHexString(color.getRed(), 2) + this.toHexString(color.getGreen(), 2) + this.toHexString(color.getBlue(), 2));
    }

    public Color getColor(String string) {
        Color color = null;
        try {
            color = Color.decode(this.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return color;
    }

    public Font getFont(String string) {
        return Font.decode(this.getString(string));
    }

    public Prefs extract(String string) {
        Prefs prefs = new Prefs();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string + ".")) continue;
            prefs.put(string2, this.get(string2));
        }
        return prefs;
    }

    public void merge(Prefs prefs) {
        Enumeration enumeration = prefs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.put(string, prefs.get(string));
        }
    }

    public String[] getStringList(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = new String(stringTokenizer.nextToken());
            ++n;
        }
        return stringArray;
    }

    public String[] getStringList(String string) {
        return this.getStringList(string, ",");
    }

    public void putStringList(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n != stringArray.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        this.putString(string, stringBuffer.toString());
    }

    public synchronized Enumeration sortedKeys() {
        Enumeration enumeration = this.keys();
        SortedList sortedList = new SortedList(StringIgnoreCaseComparer.getInstance());
        while (enumeration.hasMoreElements()) {
            sortedList.addElement((String)enumeration.nextElement());
        }
        return sortedList.elements();
    }

    void print() {
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(" * " + string + " = " + this.get(string));
        }
    }

    public Prefs(int n) {
        super(n);
    }

    public Prefs() {
    }

    static {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            userHomeProperty = "user.dir";
            userDirectory = "";
        } else {
            userHomeProperty = "user.home";
        }
    }
}

