/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.doit.muffin.Client;
import org.doit.muffin.Message;

public class Request
extends Message {
    private static RE httpRegex;
    private String command = null;
    private String url = null;
    private String protocol = null;
    private byte[] data = null;
    private Client client = null;
    private Hashtable log;
    private Vector logHeaders;

    void read(InputStream inputStream) throws IOException {
        REMatch rEMatch;
        this.statusLine = this.readLine(inputStream);
        if (this.statusLine == null || this.statusLine.length() == 0) {
            throw new IOException("Empty request");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.statusLine);
        this.command = stringTokenizer.nextToken();
        this.url = stringTokenizer.nextToken();
        this.protocol = stringTokenizer.nextToken();
        if (!this.url.startsWith("http") && (rEMatch = httpRegex.getMatch(this.url)) != null) {
            this.url = this.url.substring(rEMatch.getStartIndex(), rEMatch.getEndIndex()).toLowerCase() + this.url.substring(rEMatch.getEndIndex());
        }
        this.readHeaders(inputStream);
        if ("POST".equals(this.command) || "PUT".equals(this.command)) {
            try {
                int n = Integer.parseInt(this.getHeaderField("Content-length"));
                this.data = new byte[n];
                int n2 = 0;
                while (n2 < this.data.length) {
                    n = inputStream.read(this.data, n2, this.data.length - n2);
                    if (n < 0) {
                        throw new IOException("Not enough " + this.command + " data");
                    }
                    n2 += n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Malformed or missing " + this.command + " Content-length");
            }
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        super.write(outputStream);
        if (this.data != null) {
            outputStream.write(this.data);
            outputStream.flush();
        }
    }

    public String getRequest() {
        return this.statusLine;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getHost() {
        String string = this.getURL();
        String string2 = string.startsWith("http://") ? string.substring(7, string.indexOf(47, 7)) : string;
        int n = string2.indexOf(64);
        if (n != -1) {
            string2 = string2.substring(n + 1);
        }
        if (string2.indexOf(58) != -1) {
            return string2.substring(0, string2.indexOf(58));
        }
        return string2;
    }

    public int getPort() {
        int n = 80;
        String string = this.getURL();
        String string2 = string.startsWith("http://") ? string.substring(7, string.indexOf(47, 7)) : string;
        int n2 = string2.indexOf(64);
        if (n2 != -1) {
            string2 = string2.substring(n2 + 1);
        }
        if (string2.indexOf(58) != -1) {
            try {
                n = Integer.parseInt(string2.substring(string2.indexOf(58) + 1));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Invalid port in " + string);
            }
        }
        return n;
    }

    public String getData() {
        if (this.data == null) {
            return null;
        }
        return new String(this.data);
    }

    public String getPath() {
        String string = this.getURL();
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            n = string.indexOf(47, n);
            ++n;
            ++n2;
        }
        return string.substring(--n);
    }

    public String getDocument() {
        String string = this.getPath();
        int n = string.lastIndexOf(47);
        if (n == string.length() - 1) {
            n = string.lastIndexOf(47, n - 1);
        }
        if (n < 0) {
            return "/";
        }
        return string.substring(n + 1);
    }

    public Client getClient() {
        return this.client;
    }

    public String getQueryString() {
        String string = this.getPath();
        int n = string.indexOf(63);
        if (n < 0) {
            return null;
        }
        return string.substring(n + 1);
    }

    public synchronized void addLogEntry(String string, String string2) {
        if (this.log == null) {
            this.log = new Hashtable();
            this.logHeaders = new Vector();
        }
        Vector<String> vector = (Vector<String>)this.log.get(string);
        if (this.log.get(string) == null) {
            vector = new Vector<String>();
            this.log.put(string, vector);
            this.logHeaders.addElement(string);
        }
        vector.addElement(string2);
    }

    public Enumeration getLogHeaders() {
        return this.logHeaders != null ? this.logHeaders.elements() : null;
    }

    public Enumeration getLogEntries(String string) {
        return this.log != null ? ((Vector)this.log.get(string)).elements() : null;
    }

    Request(Client client) {
        this.client = client;
    }

    static {
        try {
            httpRegex = new RE("^(http|https):", 2);
        }
        catch (REException rEException) {
            rEException.printStackTrace();
        }
    }
}

