/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import org.doit.muffin.Cookie;
import org.doit.muffin.FilterException;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.ReplyFilter;
import org.doit.muffin.Request;
import org.doit.muffin.RequestFilter;
import org.doit.muffin.filter.CookieMonster;

public class CookieMonsterFilter
implements RequestFilter,
ReplyFilter {
    Prefs prefs;
    CookieMonster factory;
    Request request = null;

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public void filter(Request request) throws FilterException {
        this.request = request;
        if (request.containsHeaderField("Cookie")) {
            String string = request.getHeaderField("Cookie");
            if (this.prefs.getBoolean("CookieMonster.eatRequestCookies")) {
                request.removeHeaderField("Cookie");
                this.factory.report(request, "cookie \"" + string + "\"");
            }
        }
    }

    public void filter(Reply reply) throws FilterException {
        if (reply.containsHeaderField("Set-Cookie")) {
            Cookie cookie = new Cookie(reply.getHeaderField("Set-Cookie"), this.request);
            if (this.prefs.getBoolean("CookieMonster.eatReplyCookies")) {
                reply.removeHeaderField("Set-Cookie");
                this.factory.report(this.request, "set-cookie " + cookie.toString());
            }
        }
    }

    CookieMonsterFilter(CookieMonster cookieMonster) {
        this.factory = cookieMonster;
    }
}

