/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.doit.html.Tag;
import org.doit.html.Token;
import org.doit.io.InputObjectStream;
import org.doit.io.OutputObjectStream;
import org.doit.muffin.ContentFilter;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.Message;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;
import org.doit.muffin.filter.DocumentInfoFrame;

public class DocumentInfo
implements FilterFactory,
ContentFilter {
    FilterManager manager;
    Prefs prefs;
    InputObjectStream in = null;
    OutputObjectStream out = null;
    Reply reply;
    Request request;
    DocumentInfoFrame frame = null;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putString("DocumentInfo.location", "bottom");
        prefs.putString("DocumentInfo.align", "right");
        prefs.putString("DocumentInfo.info", "URL,Server,LastModified");
        prefs.putString("DocumentInfo.htmlBefore", "<small>");
        prefs.putString("DocumentInfo.htmlAfter", "</small>");
        prefs.setOverride(bl);
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new DocumentInfoFrame(this.prefs, this);
        }
        this.frame.setVisible(true);
    }

    public Filter createFilter() {
        DocumentInfo documentInfo = new DocumentInfo();
        documentInfo.setPrefs(this.prefs);
        return documentInfo;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        this.reply = reply;
        String string = reply.getContentType();
        return string != null && string.startsWith("text/html");
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    void addURL(StringBuffer stringBuffer) {
        stringBuffer.append("URL: ");
        stringBuffer.append(this.request.getURL());
        stringBuffer.append("<br>\n");
    }

    void addLastModified(StringBuffer stringBuffer) {
        if (!this.reply.containsHeaderField("Last-Modified")) {
            return;
        }
        stringBuffer.append("Last-Modified: ");
        String string = this.reply.getHeaderField("Last-Modified");
        try {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance();
            switch (string.charAt(3)) {
                case ',': {
                    simpleDateFormat.applyPattern("EEE, dd MMM yyyy HH:mm:ss z");
                    break;
                }
                case ' ': {
                    simpleDateFormat.applyPattern("EEE MMM dd HH:mm:ss yyyy");
                    break;
                }
                default: {
                    simpleDateFormat.applyPattern("EEEE, dd-MMM-yyyy HH:mm:ss z");
                    break;
                }
            }
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = simpleDateFormat.parse(this.reply.getHeaderField("Last-Modified"), parsePosition);
            stringBuffer.append(simpleDateFormat.format(date));
        }
        catch (Exception exception) {
            stringBuffer.append(string);
        }
        stringBuffer.append("<br>\n");
    }

    void addClient(StringBuffer stringBuffer) {
        stringBuffer.append("Client: ");
        stringBuffer.append(this.request.getClient().getInetAddress().getHostAddress());
        stringBuffer.append("<br>\n");
    }

    void addDate(StringBuffer stringBuffer) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance();
        simpleDateFormat.applyPattern("EEE, dd MMM yyyy HH:mm:ss z");
        stringBuffer.append("Date: ");
        stringBuffer.append(simpleDateFormat.format(new Date()));
        stringBuffer.append("<br>\n");
    }

    void addHeader(StringBuffer stringBuffer, String string) {
        Message message = null;
        if (this.request.containsHeaderField(string)) {
            message = this.request;
        } else if (this.reply.containsHeaderField(string)) {
            message = this.reply;
        }
        if (message != null) {
            int n = message.getHeaderValueCount(string) - 1;
            while (n >= 0) {
                stringBuffer.append(string);
                stringBuffer.append(": ");
                stringBuffer.append(message.getHeaderField(string, n));
                stringBuffer.append("<br>\n");
                --n;
            }
        }
    }

    String generateInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.prefs.getString("DocumentInfo.info"), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if ((string = string.trim()).equalsIgnoreCase("URL")) {
                this.addURL(stringBuffer);
                continue;
            }
            if (string.equalsIgnoreCase("Client")) {
                this.addClient(stringBuffer);
                continue;
            }
            if (string.equalsIgnoreCase("LastModified")) {
                this.addLastModified(stringBuffer);
                continue;
            }
            if (string.equalsIgnoreCase("Date")) {
                this.addDate(stringBuffer);
                continue;
            }
            this.addHeader(stringBuffer, string);
        }
        return stringBuffer.toString();
    }

    Token generateTop() {
        Token token = new Token();
        token.append(this.prefs.getString("DocumentInfo.htmlBefore"));
        token.append("<p align=");
        token.append(this.prefs.getString("DocumentInfo.align"));
        token.append(">");
        token.append(this.generateInfo());
        token.append("</p>\n");
        token.append(this.prefs.getString("DocumentInfo.htmlAfter"));
        return token;
    }

    Token generateBottom() {
        Token token = new Token();
        token.append(this.prefs.getString("DocumentInfo.htmlBefore"));
        token.append("<p align=");
        token.append(this.prefs.getString("DocumentInfo.align"));
        token.append(">");
        token.append(this.generateInfo());
        token.append("</p>\n");
        token.append(this.prefs.getString("DocumentInfo.htmlAfter"));
        return token;
    }

    /*
     * Loose catch block
     */
    public void run() {
        block13: {
            block12: {
                Object object;
                Thread.currentThread().setName("DocumentInfo");
                boolean bl = false;
                while ((object = this.in.read()) != null) {
                    Token token = (Token)object;
                    if (token.getType() == 2) {
                        Tag tag = token.createTag();
                        if (tag.is("body") && this.prefs.getString("DocumentInfo.location").equals("top")) {
                            this.out.write(object);
                            this.out.write(this.generateTop());
                            bl = true;
                            continue;
                        }
                        if (tag.is("/body") && this.prefs.getString("DocumentInfo.location").equals("bottom")) {
                            this.out.write(this.generateBottom());
                            this.out.write(object);
                            bl = true;
                            continue;
                        }
                        this.out.write(object);
                        continue;
                    }
                    this.out.write(object);
                }
                if (bl) break block12;
                this.out.write(this.generateBottom());
            }
            Object var2_9 = null;
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException iOException) {}
            break block13;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var2_10 = null;
                    try {
                        this.out.flush();
                        this.out.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var2_11 = null;
                try {
                    this.out.flush();
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

