/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.Prefs;
import org.doit.muffin.UserFile;
import org.doit.muffin.filter.GlossaryFilter;
import org.doit.muffin.filter.GlossaryFrame;

public class Glossary
extends Hashtable
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    GlossaryFrame frame = null;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        String string = "glossary";
        prefs.putString("Glossary.glossaryfile", string);
        prefs.setOverride(bl);
        this.load();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new GlossaryFrame(this.prefs, this);
        }
        this.frame.setVisible(true);
    }

    public Filter createFilter() {
        GlossaryFilter glossaryFilter = new GlossaryFilter(this);
        glossaryFilter.setPrefs(this.prefs);
        return glossaryFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    String lookup(String string) {
        return (String)this.get(string.toLowerCase());
    }

    void load() {
        try {
            String string;
            UserFile userFile = this.prefs.getUserFile(this.prefs.getString("Glossary.glossaryfile"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(userFile.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                this.put(string2.toLowerCase(), string3);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Glossary() {
        super(33);
    }
}

