/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.doit.muffin.AutoSaveable;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.Prefs;
import org.doit.muffin.filter.HistoryData;
import org.doit.muffin.filter.HistoryDataCountComparer;
import org.doit.muffin.filter.HistoryDataTimeComparer;
import org.doit.muffin.filter.HistoryFilter;
import sdsu.util.SortedList;

public class History
implements FilterFactory,
AutoSaveable {
    private Hashtable data;
    FilterManager manager;
    Prefs prefs;

    HistoryData get(String string) {
        HistoryData historyData = (HistoryData)this.data.get(string);
        if (historyData == null) {
            historyData = new HistoryData();
            historyData.url = string;
            historyData.time = 0L;
            historyData.count = 0L;
            this.put(string, historyData);
        }
        return historyData;
    }

    void put(String string, HistoryData historyData) {
        this.data.put(string, historyData);
    }

    Enumeration keys() {
        return this.data.keys();
    }

    Enumeration sortByCount() {
        SortedList sortedList = new SortedList(HistoryDataCountComparer.getInstance());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            sortedList.addElement(this.get((String)enumeration.nextElement()));
        }
        return sortedList.elements();
    }

    Enumeration sortByTime() {
        SortedList sortedList = new SortedList(HistoryDataTimeComparer.getInstance());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            sortedList.addElement(this.get((String)enumeration.nextElement()));
        }
        return sortedList.elements();
    }

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putString("History.histfile", "history");
        prefs.setOverride(bl);
        this.loadData();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
    }

    public Filter createFilter() {
        HistoryFilter historyFilter = new HistoryFilter(this);
        historyFilter.setPrefs(this.prefs);
        return historyFilter;
    }

    public void shutdown() {
        this.saveData();
    }

    public void autoSave() {
        History history = this;
        synchronized (history) {
            this.saveData();
        }
    }

    void save() {
        this.manager.save(this);
    }

    /*
     * Loose catch block
     */
    void loadData() {
        block14: {
            InputStream inputStream = null;
            Object object2222 = this.prefs.getUserFile(this.prefs.getString("History.histfile"));
            inputStream = object2222.getInputStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            this.data = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            Object var3_9 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block14;
            }
            catch (IOException object2222) {}
            break block14;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    Object var3_10 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    this.data = new Hashtable();
                    Object var3_11 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_12 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    void saveData() {
        block11: {
            OutputStream outputStream = null;
            outputStream = this.prefs.getUserFile(this.prefs.getString("History.histfile")).getOutputStream();
            Object object2222 = new ObjectOutputStream(outputStream);
            ((ObjectOutputStream)object2222).writeObject(this.data);
            ((ObjectOutputStream)object2222).flush();
            ((ObjectOutputStream)object2222).close();
            Object var3_6 = null;
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                break block11;
            }
            catch (IOException object2222) {}
            break block11;
            {
                catch (IOException iOException) {
                    System.out.println(iOException);
                    Object var3_7 = null;
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        break block11;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_8 = null;
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

