/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.MessageArea;
import org.doit.muffin.Prefs;
import org.doit.muffin.Request;
import org.doit.muffin.filter.ImageKillFilter;
import org.doit.muffin.filter.ImageKillFrame;

public class ImageKill
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    ImageKillFrame frame = null;
    MessageArea messages = null;
    private RE exclude = null;
    private Hashtable removeSizes = null;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        prefs.putInteger("ImageKill.minheight", 49);
        prefs.putInteger("ImageKill.minwidth", 300);
        prefs.putInteger("ImageKill.ratio", 6);
        prefs.putBoolean("ImageKill.keepmaps", true);
        prefs.putString("ImageKill.exclude", "(button|map)");
        prefs.putString("ImageKill.rmSizes", "468x60,450x40");
        prefs.putBoolean("ImageKill.replace", false);
        prefs.putString("ImageKill.replaceURL", "file:/usr/local/images/empty.gif");
        prefs.setOverride(bl);
        this.messages = new MessageArea();
        this.setExclude();
        this.setRemoveSizes();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new ImageKillFrame(this.prefs, this);
        }
        this.frame.setVisible(true);
    }

    public Filter createFilter() {
        ImageKillFilter imageKillFilter = new ImageKillFilter(this);
        imageKillFilter.setPrefs(this.prefs);
        return imageKillFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    void report(Request request, String string) {
        request.addLogEntry("ImageKill", string);
        this.messages.append(string + "\n");
    }

    public void setExclude() {
        this.exclude = null;
        String string = this.prefs.getString("ImageKill.exclude");
        if (string != null && !string.equals("")) {
            try {
                this.exclude = new RE(string);
            }
            catch (REException rEException) {
                System.out.println("ImageKill REException: " + rEException.getMessage());
            }
        }
    }

    boolean isExcluded(String string) {
        return this.exclude != null && this.exclude.getMatch(string) != null;
    }

    public void setRemoveSizes() {
        try {
            this.removeSizes = new Hashtable();
            String string = this.prefs.getString("ImageKill.rmSizes");
            if (string == null || string.equals("")) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "x");
                Integer n = new Integer(Integer.parseInt(stringTokenizer2.nextToken()));
                Integer n2 = new Integer(Integer.parseInt(stringTokenizer2.nextToken()));
                Vector<Integer> vector = (Vector<Integer>)this.removeSizes.get(n);
                if (vector == null) {
                    vector = new Vector<Integer>();
                    this.removeSizes.put(n, vector);
                }
                vector.addElement(n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean inRemoveSizes(int n, int n2) {
        if (this.removeSizes != null) {
            try {
                Integer n3 = new Integer(n);
                Vector vector = (Vector)this.removeSizes.get(n3);
                if (vector != null && vector.contains(new Integer(n2))) {
                    return true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }
}

