/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.io.IOException;
import org.doit.html.Tag;
import org.doit.html.Token;
import org.doit.io.InputObjectStream;
import org.doit.io.OutputObjectStream;
import org.doit.muffin.ContentFilter;
import org.doit.muffin.FilterException;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.ReplyFilter;
import org.doit.muffin.Request;
import org.doit.muffin.filter.NoCode;

public class NoCodeFilter
implements ContentFilter,
ReplyFilter {
    NoCode factory;
    Prefs prefs;
    InputObjectStream in = null;
    OutputObjectStream out = null;
    Request request = null;

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public void filter(Reply reply) throws FilterException {
        String string;
        if (this.prefs.getBoolean("NoCode.noJavaScript") && (string = reply.getContentType()) != null && string.equalsIgnoreCase("application/x-javascript")) {
            this.factory.report(this.request, "rejecting " + string);
            throw new FilterException("NoCode " + string + " rejected");
        }
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        String string = reply.getContentType();
        return string != null && string.startsWith("text/html");
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    private static boolean startsWithIgnoreCase(String string, String string2) {
        String string3 = string.substring(0, Math.min(string.length(), string2.length()));
        return string3.equalsIgnoreCase(string2);
    }

    private String BaseLanguage(String string) {
        if (NoCodeFilter.startsWithIgnoreCase(string, "JScript.Encode")) {
            return "JavaScript.Encode";
        }
        if (NoCodeFilter.startsWithIgnoreCase(string, "EcmaScript.Encode")) {
            return "JavaScript.Encode";
        }
        if (NoCodeFilter.startsWithIgnoreCase(string, "JavaScript.Encode")) {
            return "JavaScript.Encode";
        }
        if (NoCodeFilter.startsWithIgnoreCase(string, "LiveScript.Encode")) {
            return "JavaScript.Encode";
        }
        if (NoCodeFilter.startsWithIgnoreCase(string, "VBScript.Encode")) {
            return "VBScript.Encode";
        }
        if (NoCodeFilter.startsWithIgnoreCase(string, "VBS.Encode")) {
            return "VBScript.Encode";
        }
        if (NoCodeFilter.startsWithIgnoreCase(string, "JScript")) {
            return "JavaScript";
        }
        if (NoCodeFilter.startsWithIgnoreCase(string, "EcmaScript")) {
            return "JavaScript";
        }
        if (NoCodeFilter.startsWithIgnoreCase(string, "JavaScript")) {
            return "JavaScript";
        }
        if (NoCodeFilter.startsWithIgnoreCase(string, "LiveScript")) {
            return "JavaScript";
        }
        if (NoCodeFilter.startsWithIgnoreCase(string, "VBScript")) {
            return "VBScript";
        }
        if (NoCodeFilter.startsWithIgnoreCase(string, "VBS")) {
            return "VBScript";
        }
        return string;
    }

    public boolean IsBadLanguage(String string) {
        boolean bl = this.prefs.getBoolean("NoCode.noJavaScript");
        boolean bl2 = this.prefs.getBoolean("NoCode.noVBScript");
        boolean bl3 = this.prefs.getBoolean("NoCode.noEncodedScript");
        boolean bl4 = this.prefs.getBoolean("NoCode.noOtherScript");
        return string.equals("JavaScript") ? bl : (string.equals("VBScript") ? bl2 : (string.equals("JavaScript.Encode") ? bl || bl3 : (string.equals("VBScript.Encode") ? bl2 || bl3 : bl4)));
    }

    /*
     * Loose catch block
     */
    public void run() {
        block29: {
            Object object;
            Thread.currentThread().setName("NoCode");
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = this.prefs.getBoolean("NoCode.noJavaScript");
            boolean bl6 = this.prefs.getBoolean("NoCode.noVBScript");
            boolean bl7 = this.prefs.getBoolean("NoCode.noOtherScript");
            boolean bl8 = this.prefs.getBoolean("NoCode.noEncodedScript");
            boolean bl9 = bl5 || bl6 || bl7 || bl8;
            boolean bl10 = this.prefs.getBoolean("NoCode.noEvalInScript");
            boolean bl11 = this.prefs.getBoolean("NoCode.noJava");
            while ((object = this.in.read()) != null) {
                String string;
                Object object2;
                CharSequence charSequence;
                Token token = (Token)object;
                if (token.getType() == 2) {
                    Tag tag = token.createTag();
                    if (bl2 && tag.is("/script")) {
                        bl2 = false;
                        bl3 = false;
                    }
                    if (bl && tag.is("/script")) {
                        bl = false;
                        continue;
                    }
                    if (bl4 && tag.is("/applet")) {
                        bl4 = false;
                        continue;
                    }
                    if (tag.is("script")) {
                        bl2 = true;
                        if (tag.has("language")) {
                            charSequence = this.BaseLanguage(tag.get("language"));
                            if (this.IsBadLanguage((String)charSequence)) {
                                bl = true;
                                this.factory.report(this.request, "Removed <script bad language>");
                            }
                            if (((String)charSequence).equals("VBScript") || ((String)charSequence).equals("VBScript.Encode")) {
                                bl3 = true;
                            }
                        } else if (bl9) {
                            bl = true;
                            this.factory.report(this.request, "Removed <script without language>");
                        }
                    } else if (this.factory.isJavaScriptTag(tag.name()) && tag.attributeCount() > 0 && bl9) {
                        charSequence = new StringBuffer();
                        object2 = tag.enumerate();
                        while (object2.hasMoreElements()) {
                            String string2 = (String)object2.nextElement();
                            if (!this.factory.isJavaScriptAttr(string2) || (string = tag.remove(string2)) == null) continue;
                            ((StringBuffer)charSequence).append("<");
                            ((StringBuffer)charSequence).append(tag.name());
                            ((StringBuffer)charSequence).append("> ");
                            ((StringBuffer)charSequence).append(string2);
                            ((StringBuffer)charSequence).append("=\"");
                            ((StringBuffer)charSequence).append(string);
                            ((StringBuffer)charSequence).append("\" ");
                        }
                        if (tag.has("href") && (NoCodeFilter.startsWithIgnoreCase(tag.get("href"), "javascript:") && bl5 || NoCodeFilter.startsWithIgnoreCase(tag.get("href"), "vbscript:") && bl6)) {
                            string = tag.remove("href");
                            ((StringBuffer)charSequence).append("<");
                            ((StringBuffer)charSequence).append(tag.name());
                            ((StringBuffer)charSequence).append("> ");
                            ((StringBuffer)charSequence).append("href=\"");
                            ((StringBuffer)charSequence).append(string);
                            ((StringBuffer)charSequence).append("\" ");
                        }
                        if (tag.has("language") && this.IsBadLanguage(tag.get("language"))) {
                            string = tag.remove("language");
                            ((StringBuffer)charSequence).append("<");
                            ((StringBuffer)charSequence).append(tag.name());
                            ((StringBuffer)charSequence).append("> ");
                            ((StringBuffer)charSequence).append("language=\"");
                            ((StringBuffer)charSequence).append(string);
                            ((StringBuffer)charSequence).append("\" ");
                        }
                        if (((StringBuffer)charSequence).length() > 0) {
                            this.factory.report(this.request, ((StringBuffer)charSequence).toString());
                        }
                    }
                    if (bl11 && tag.is("applet")) {
                        bl4 = true;
                        this.factory.report(this.request, "Removed <applet>");
                    }
                    if (bl || bl4) continue;
                    token.importTag(tag);
                    this.out.write(token);
                    continue;
                }
                if (bl || bl4) continue;
                if (bl2 && bl10) {
                    try {
                        charSequence = bl3 ? "MsgBox" : "alert";
                        string = token.toString();
                        object2 = new RE("eval", 2);
                        string = ((RE)object2).substituteAll(string, (String)charSequence);
                        object2 = new RE("executeglobal", 2);
                        string = ((RE)object2).substituteAll(string, (String)charSequence);
                        object2 = new RE("execute", 2);
                        string = ((RE)object2).substituteAll(string, (String)charSequence);
                        token.erase();
                        token.append(string);
                    }
                    catch (REException rEException) {
                        rEException.printStackTrace();
                    }
                }
                this.out.write(token);
            }
            Object var2_24 = null;
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException iOException) {}
            break block29;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var2_25 = null;
                    try {
                        this.out.flush();
                        this.out.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var2_26 = null;
                try {
                    this.out.flush();
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    NoCodeFilter(NoCode noCode) {
        this.factory = noCode;
    }
}

