/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.doit.muffin.ImageCanvas;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;

class PreviewDialog
extends Dialog
implements ActionListener,
WindowListener {
    byte[] content = null;
    boolean accepted = true;
    TextArea text = null;
    Image image = null;
    Frame frame = null;

    public boolean accept() {
        return this.accepted;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("doAccept".equals(string)) {
            this.accepted = true;
            if (this.text != null) {
                this.content = this.text.getText().getBytes();
            }
            ((Component)this).setVisible(false);
        } else if ("doReject".equals(string)) {
            this.accepted = false;
            ((Component)this).setVisible(false);
        } else if ("doSaveAs".equals(string)) {
            try {
                FileDialog fileDialog = new FileDialog(this.frame, "Save Content");
                fileDialog.show();
                if (fileDialog.getFile() != null) {
                    File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(this.content);
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    PreviewDialog(Frame frame, Request request, Reply reply, byte[] byArray) {
        super(frame, "Muffin: Preview " + request.getURL(), true);
        Component component;
        this.content = byArray;
        this.frame = frame;
        if (reply.getContentType().startsWith("text")) {
            this.text = new TextArea();
            this.text.setEditable(true);
            this.text.setText(new String(byArray));
            this.add("Center", this.text);
        } else if (reply.getContentType().startsWith("image")) {
            this.image = Toolkit.getDefaultToolkit().createImage(byArray);
            component = new ImageCanvas(this.image);
            this.add("Center", component);
        }
        component = new Panel();
        ((Container)component).setLayout(new GridLayout(1, 3));
        Button button = new Button("Accept");
        button.setActionCommand("doAccept");
        button.addActionListener(this);
        ((Container)component).add(button);
        button = new Button("Reject");
        button.setActionCommand("doReject");
        button.addActionListener(this);
        ((Container)component).add(button);
        button = new Button("Save as");
        button.setActionCommand("doSaveAs");
        button.addActionListener(this);
        ((Container)component).add(button);
        this.add("South", component);
        this.addWindowListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
    }
}

