/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.util.Hashtable;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;
import org.doit.muffin.filter.StatsFilter;
import org.doit.muffin.filter.StatsFrame;

public class Stats
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    StatsFrame frame = null;
    int requests;
    int replies;
    Hashtable hosts;
    Hashtable servers;
    Hashtable contentLengths;
    Hashtable contentTypes;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new StatsFrame(this.prefs, this);
        }
        this.frame.setVisible(true);
    }

    public Filter createFilter() {
        StatsFilter statsFilter = new StatsFilter(this);
        statsFilter.setPrefs(this.prefs);
        return statsFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    void increment(Hashtable hashtable, String string, int n) {
        Integer n2 = (Integer)hashtable.get(string);
        if (n2 == null) {
            n2 = new Integer(0);
        }
        n2 = new Integer(n2 + n);
        hashtable.put(string, n2);
    }

    synchronized void recordRequest(Request request) {
        ++this.requests;
        String string = request.getHost();
        this.increment(this.hosts, string != null ? string : "null", 1);
    }

    synchronized void recordReply(Reply reply) {
        ++this.replies;
        String string = reply.getContentType();
        this.increment(this.contentTypes, string != null ? string : "null", 1);
        if (string != null) {
            try {
                int n = Integer.parseInt(reply.getHeaderField("Content-length"));
                this.increment(this.contentLengths, string, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.increment(this.servers, (string = reply.getHeaderField("Server")) != null ? string : "null", 1);
    }

    void reset() {
        this.requests = 0;
        this.replies = 0;
        this.hosts = new Hashtable(100);
        this.servers = new Hashtable(100);
        this.contentTypes = new Hashtable(100);
        this.contentLengths = new Hashtable(100);
    }

    public Stats() {
        this.reset();
    }
}

