/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class ARecord
extends Record {
    private InetAddress address;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.address != null) {
            stringBuffer.append(this.address.getHostAddress());
        }
        return stringBuffer.toString();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.address == null) {
            return;
        }
        dataByteOutputStream.write(this.address.getAddress());
    }

    private ARecord() {
    }

    public ARecord(Name name, short s, int n, InetAddress inetAddress) throws IOException {
        super(name, (short)1, s, n);
        this.address = inetAddress;
    }

    ARecord(Name name, short s, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, (short)1, s, n);
        if (dataByteInputStream == null) {
            return;
        }
        byte[] byArray = new byte[4];
        dataByteInputStream.read(byArray);
        String string = (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
        try {
            this.address = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Invalid IP address " + string);
        }
    }

    ARecord(Name name, short s, int n, MyStringTokenizer myStringTokenizer, Name name2) throws IOException {
        super(name, (short)1, s, n);
        String string = myStringTokenizer.nextToken();
        if (string.equals("@me@")) {
            try {
                this.address = InetAddress.getLocalHost();
                if (this.address.equals(InetAddress.getByName("127.0.0.1"))) {
                    System.out.println("InetAddress.getLocalHost() is broken.  For now, don't use @me@");
                    System.exit(-1);
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.address = null;
            }
        } else {
            this.address = InetAddress.getByName(string);
        }
    }
}

