/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.dns;
import org.xbill.DNS.utils.MyStringTokenizer;

public final class Address {
    private static boolean isDottedQuad(String string) {
        MyStringTokenizer myStringTokenizer = new MyStringTokenizer(string, ".");
        boolean bl = false;
        int[] nArray = new int[4];
        int n = 0;
        while (n < 4) {
            if (!myStringTokenizer.hasMoreTokens()) break;
            try {
                nArray[n] = Integer.parseInt(myStringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            if (nArray[n] < 0 || nArray[n] > 255) break;
            ++n;
        }
        return n == 4;
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        if (Address.isDottedQuad(string)) {
            return InetAddress.getByName(string);
        }
        Record[] recordArray = dns.getRecords(string, (short)1);
        if (recordArray == null) {
            throw new UnknownHostException("unknown host");
        }
        ARecord aRecord = (ARecord)recordArray[0];
        return aRecord.getAddress();
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        if (Address.isDottedQuad(string)) {
            return InetAddress.getAllByName(string);
        }
        Record[] recordArray = dns.getRecords(string, (short)1);
        if (recordArray == null) {
            throw new UnknownHostException("unknown host");
        }
        InetAddress[] inetAddressArray = new InetAddress[recordArray.length];
        int n = 0;
        while (n < recordArray.length) {
            ARecord aRecord = (ARecord)recordArray[n];
            inetAddressArray[n] = aRecord.getAddress();
            ++n;
        }
        return inetAddressArray;
    }

    public static String getHostName(InetAddress inetAddress) throws UnknownHostException {
        Record[] recordArray = dns.getRecordsByAddress(inetAddress.getHostAddress(), (short)12);
        if (recordArray == null) {
            throw new UnknownHostException("unknown address");
        }
        PTRRecord pTRRecord = (PTRRecord)recordArray[0];
        return pTRRecord.getTarget().toString();
    }
}

