/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base64;

public class CERTRecord
extends Record {
    public static final int PKIX = 1;
    public static final int SPKI = 2;
    public static final int PGP = 3;
    public static final int URL = 253;
    public static final int OID = 254;
    private short certType;
    private short keyTag;
    private byte alg;
    private byte[] cert;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.cert != null) {
            stringBuffer.append(this.certType);
            stringBuffer.append(" ");
            stringBuffer.append(this.keyTag);
            stringBuffer.append(" ");
            stringBuffer.append(this.alg);
            if (this.cert != null) {
                stringBuffer.append(" (\n");
                stringBuffer.append(base64.formatString(this.cert, 64, "\t", true));
            }
        }
        return stringBuffer.toString();
    }

    public short getCertType() {
        return this.certType;
    }

    public short getKeyTag() {
        return this.keyTag;
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public byte[] getCert() {
        return this.cert;
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.cert == null) {
            return;
        }
        dataByteOutputStream.writeShort(this.certType);
        dataByteOutputStream.writeShort(this.keyTag);
        dataByteOutputStream.writeByte(this.alg);
        dataByteOutputStream.write(this.cert);
    }

    private CERTRecord() {
    }

    public CERTRecord(Name name, short s, int n, int n2, int n3, int n4, byte[] byArray) {
        super(name, (short)37, s, n);
        this.certType = (short)n2;
        this.keyTag = (short)n3;
        this.alg = (byte)n4;
        this.cert = byArray;
    }

    CERTRecord(Name name, short s, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, (short)37, s, n);
        if (dataByteInputStream == null) {
            return;
        }
        this.certType = dataByteInputStream.readShort();
        this.keyTag = dataByteInputStream.readShort();
        this.alg = dataByteInputStream.readByte();
        if (n2 > 5) {
            this.cert = new byte[n2 - 5];
            dataByteInputStream.read(this.cert);
        }
    }

    CERTRecord(Name name, short s, int n, MyStringTokenizer myStringTokenizer, Name name2) throws IOException {
        super(name, (short)37, s, n);
        this.certType = (short)Integer.parseInt(myStringTokenizer.nextToken());
        this.keyTag = (short)Integer.parseInt(myStringTokenizer.nextToken());
        this.alg = (byte)Integer.parseInt(myStringTokenizer.nextToken());
        this.cert = base64.fromString(myStringTokenizer.remainingTokens());
    }
}

