/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Enumeration;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Master;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameSet;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.Type;

public class Cache
extends NameSet {
    public void addRecord(Record record, byte by, Object object) {
        int n;
        Name name = record.getName();
        short s = record.getRRsetType();
        short s2 = record.getDClass();
        if (!Type.isRR(s)) {
            return;
        }
        int n2 = n = object != null ? object.hashCode() : 0;
        if (record.getTTL() == 0) {
            return;
        }
        Element element = (Element)this.findExactSet(name, s, s2);
        if (element == null || by > element.credibility) {
            Cache cache = this;
            if (cache == null) {
                throw null;
            }
            element = cache.new Element(record, by, n);
            this.addSet(name, s, s2, element);
        } else if (by == element.credibility) {
            if (element.srcid != n) {
                element.rrset.clear();
            }
            element.update(record);
        }
    }

    public void addRRset(RRset rRset, byte by, Object object) {
        int n;
        Name name = rRset.getName();
        short s = rRset.getType();
        short s2 = rRset.getDClass();
        int n2 = n = object != null ? object.hashCode() : 0;
        if (rRset.getTTL() == 0) {
            return;
        }
        Element element = (Element)this.findExactSet(name, s, s2);
        if (element == null || by > element.credibility) {
            Cache cache = this;
            if (cache == null) {
                throw null;
            }
            this.addSet(name, s, s2, cache.new Element(rRset, by, n));
        }
    }

    public void addNegative(Name name, short s, short s2, int n, byte by, Object object) {
        int n2 = object != null ? object.hashCode() : 0;
        Element element = (Element)this.findExactSet(name, s, s2);
        if (element == null || by > element.credibility) {
            Cache cache = this;
            if (cache == null) {
                throw null;
            }
            this.addSet(name, s, s2, cache.new Element(n, by, n2));
        }
    }

    public SetResponse lookupRecords(Name name, short s, short s2, byte by) {
        SetResponse setResponse = null;
        Object[] objectArray = this.findSets(name, s, s2);
        if (objectArray == null) {
            return new SetResponse(0);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            Element element = (Element)objectArray[n2];
            if (element.expiredTTL()) {
                this.removeSet(name, s, s2, element);
                objectArray[n2] = null;
            } else if (element.credibility < by) {
                objectArray[n2] = null;
            } else {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return new SetResponse(0);
        }
        Element[] elementArray = new Element[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3] != null) {
                elementArray[n4++] = (Element)objectArray[n3];
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < elementArray.length) {
            RRset rRset = elementArray[n3].rrset;
            if (rRset == null) {
                if (s != 255) {
                    return new SetResponse(1);
                }
            } else {
                if (s != 5 && s != 255 && rRset.getType() == 5) {
                    CNAMERecord cNAMERecord = (CNAMERecord)rRset.first();
                    setResponse = this.lookupRecords(cNAMERecord.getTarget(), s, s2, by);
                    if (setResponse.isUnknown()) {
                        setResponse.set((byte)4, cNAMERecord);
                    }
                    setResponse.addCNAME(cNAMERecord);
                    return setResponse;
                }
                if (setResponse == null) {
                    setResponse = new SetResponse(5);
                }
                setResponse.addRRset(rRset);
            }
            ++n3;
        }
        if (setResponse == null && s == 255) {
            return new SetResponse(1);
        }
        return setResponse;
    }

    private RRset[] findRecords(Name name, short s, short s2, byte by) {
        SetResponse setResponse = this.lookupRecords(name, s, s2, by);
        if (setResponse.isSuccessful()) {
            return setResponse.answers();
        }
        return null;
    }

    public RRset[] findRecords(Name name, short s, short s2) {
        return this.findRecords(name, s, s2, (byte)2);
    }

    public RRset[] findAnyRecords(Name name, short s, short s2) {
        return this.findRecords(name, s, s2, (byte)1);
    }

    public void addMessage(Message message) {
        byte by;
        Record record;
        boolean bl = message.getHeader().getFlag(5);
        Name name = message.getQuestion().getName();
        short s = message.getQuestion().getType();
        short s2 = message.getQuestion().getDClass();
        short s3 = message.getHeader().getRcode();
        int n = message.getHeader().getCount(1);
        if (s3 != 0 && s3 != 3) {
            return;
        }
        Enumeration enumeration = message.getSection(1);
        while (enumeration.hasMoreElements()) {
            record = (Record)enumeration.nextElement();
            by = bl && record.getName().equals(name) ? (byte)5 : (bl ? (byte)2 : 2);
            this.addRecord(record, by, message);
        }
        if (n == 0 || s3 == 3) {
            record = null;
            enumeration = message.getSection(2);
            while (enumeration.hasMoreElements()) {
                Record record2 = (Record)enumeration.nextElement();
                if (record2.getType() != 6) continue;
                record = (SOARecord)record2;
                break;
            }
            by = bl ? (byte)4 : 1;
            if (record != null) {
                int n2 = Math.min(record.getTTL(), ((SOARecord)record).getMinimum());
                if (n == 0) {
                    this.addNegative(name, s, s2, n2, by, message);
                } else {
                    Record[] recordArray = message.getSectionArray(1);
                    int n3 = recordArray.length - 1;
                    Name name2 = ((CNAMERecord)recordArray[n3]).getTarget();
                    this.addNegative(name2, s, s2, n2, by, message);
                }
            }
        }
        enumeration = message.getSection(2);
        while (enumeration.hasMoreElements()) {
            record = (Record)enumeration.nextElement();
            by = bl ? (byte)4 : 1;
            this.addRecord(record, by, message);
        }
        enumeration = message.getSection(3);
        while (enumeration.hasMoreElements()) {
            record = (Record)enumeration.nextElement();
            by = bl ? (byte)1 : 1;
            this.addRecord(record, by, message);
        }
    }

    void flushSet(Name name, short s, short s2) {
        Element element = (Element)this.findExactSet(name, s, s2);
        if (element == null || element.rrset == null) {
            return;
        }
        this.removeSet(name, s, s2, element);
    }

    void flushName(Name name) {
        this.removeName(name);
    }

    public Cache() {
    }

    public Cache(String string) throws IOException {
        Record record;
        Master master = new Master(string);
        while ((record = master.nextRecord()) != null) {
            this.addRecord(record, (byte)3, master);
        }
    }

    private class Element {
        RRset rrset;
        byte credibility;
        long timeIn;
        int ttl;
        int srcid;

        public void update(Record record) {
            this.rrset.addRR(record);
            this.timeIn = System.currentTimeMillis();
            if (this.ttl < 0) {
                this.ttl = record.getTTL();
            }
        }

        public void deleteRecord(Record record) {
            this.rrset.deleteRR(record);
        }

        public boolean expiredTTL() {
            return System.currentTimeMillis() > this.timeIn + (long)(1000 * this.ttl);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.rrset);
            stringBuffer.append(" cl = ");
            stringBuffer.append(this.credibility);
            return stringBuffer.toString();
        }

        public Element(int n, byte by, int n2) {
            this.rrset = null;
            this.credibility = by;
            this.ttl = n;
            this.srcid = n2;
            this.timeIn = System.currentTimeMillis();
        }

        public Element(Record record, byte by, int n) {
            this.rrset = new RRset();
            this.credibility = by;
            this.ttl = -1;
            this.srcid = n;
            this.update(record);
        }

        public Element(RRset rRset, byte by, int n) {
            this.rrset = rRset;
            this.credibility = by;
            this.ttl = -1;
            this.timeIn = System.currentTimeMillis();
            this.ttl = rRset.getTTL();
            this.srcid = n;
        }
    }
}

