/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Random;
import org.xbill.DNS.Flags;
import org.xbill.DNS.Opcode;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Section;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class Header {
    private int id;
    private boolean[] flags;
    private byte rcode;
    private byte opcode;
    private int[] counts = new int[4];

    void toWire(DataByteOutputStream dataByteOutputStream) throws IOException {
        dataByteOutputStream.writeShort(this.getID());
        this.writeFlags(dataByteOutputStream);
        int n = 0;
        while (n < this.counts.length) {
            dataByteOutputStream.writeShort((short)this.counts[n]);
            ++n;
        }
    }

    public byte[] toWire() throws IOException {
        DataByteOutputStream dataByteOutputStream = new DataByteOutputStream();
        this.toWire(dataByteOutputStream);
        return dataByteOutputStream.toByteArray();
    }

    public void setFlag(int n) {
        this.flags[n] = true;
    }

    public void unsetFlag(int n) {
        this.flags[n] = false;
    }

    public boolean getFlag(int n) {
        return this.flags[n];
    }

    boolean[] getFlags() {
        return this.flags;
    }

    public int getID() {
        return this.id & 0xFFFF;
    }

    public void setID(int n) {
        this.id = n;
    }

    static short randomID() {
        Random random = new Random();
        return (short)(random.nextInt() & 0xFFFF);
    }

    public void setRcode(byte by) {
        this.rcode = by;
    }

    public byte getRcode() {
        return this.rcode;
    }

    public void setOpcode(byte by) {
        this.opcode = by;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    void setCount(int n, int n2) {
        this.counts[n] = n2;
    }

    void incCount(int n) {
        int n2 = n;
        this.counts[n2] = this.counts[n2] + 1;
    }

    void decCount(int n) {
        int n2 = n;
        this.counts[n2] = this.counts[n2] - 1;
    }

    public int getCount(int n) {
        return this.counts[n];
    }

    private void writeFlags(DataByteOutputStream dataByteOutputStream) throws IOException {
        int n = 0;
        short s = 0;
        int n2 = 0;
        while (n2 < 8) {
            if (this.flags[n2]) {
                n = (short)(n | 1 << 7 - n2);
            }
            if (this.flags[n2 + 8]) {
                s = (short)(s | 1 << 7 - n2);
            }
            ++n2;
        }
        n = (short)(n | this.opcode << 3);
        s = (short)(s | this.rcode);
        dataByteOutputStream.writeByte(n);
        dataByteOutputStream.writeByte(s);
    }

    private void readFlags(DataByteInputStream dataByteInputStream) throws IOException {
        short s = (short)dataByteInputStream.readUnsignedByte();
        short s2 = (short)dataByteInputStream.readUnsignedByte();
        int n = 0;
        while (n < 8) {
            this.flags[n] = (s & 1 << 7 - n) != 0;
            this.flags[n + 8] = (s2 & 1 << 7 - n) != 0;
            ++n;
        }
        this.opcode = (byte)(s >> 3 & 0xF);
        this.rcode = (byte)(s2 & 0xF);
    }

    public String printFlags() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.flags.length) {
            String string;
            if (this.getFlag(n) && (string = Flags.string(n)) != null) {
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(";; ->>HEADER<<- ");
        stringBuffer.append("opcode: " + Opcode.string(this.getOpcode()));
        stringBuffer.append(", status: " + Rcode.string(this.getRcode()));
        stringBuffer.append(", id: " + this.getID());
        stringBuffer.append("\n");
        stringBuffer.append(";; flags: " + this.printFlags());
        stringBuffer.append("; ");
        int n = 0;
        while (n < 4) {
            stringBuffer.append(Section.string(n) + ": " + this.getCount(n) + " ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        Header header = new Header();
        int n = 0;
        while (n < this.counts.length) {
            header.counts[n] = this.counts[n];
            ++n;
        }
        n = 0;
        while (n < this.flags.length) {
            header.flags[n] = this.flags[n];
            ++n;
        }
        header.id = this.id;
        header.rcode = this.rcode;
        header.rcode = this.rcode;
        header.opcode = this.opcode;
        return header;
    }

    public Header(int n) {
        this.flags = new boolean[16];
        this.id = n;
    }

    public Header() {
        this(Header.randomID());
    }

    public Header(DataByteInputStream dataByteInputStream) throws IOException {
        this(dataByteInputStream.readUnsignedShort());
        this.readFlags(dataByteInputStream);
        int n = 0;
        while (n < this.counts.length) {
            this.counts[n] = dataByteInputStream.readUnsignedShort();
            ++n;
        }
    }
}

