/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base64;

public class KEYRecord
extends Record {
    public static final int NOCONF = 32768;
    public static final int NOAUTH = 16384;
    public static final int ZONE = 4096;
    public static final int HOST = 8192;
    public static final int USER = 0;
    public static final int TLS = 1;
    public static final int EMAIL = 2;
    public static final int DNSSEC = 3;
    public static final int IPSEC = 4;
    public static final int ANY = 255;
    private short flags;
    private byte proto;
    private byte alg;
    private byte[] key;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.key != null || (this.flags & 0xC000) == 49152) {
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toHexString(this.flags & 0xFFFF));
            stringBuffer.append(" ");
            stringBuffer.append(this.proto);
            stringBuffer.append(" ");
            stringBuffer.append(this.alg);
            if (this.key != null) {
                stringBuffer.append(" (\n");
                stringBuffer.append(base64.formatString(this.key, 64, "\t", true));
            }
        }
        return stringBuffer.toString();
    }

    public short getFlags() {
        return this.flags;
    }

    public byte getProtocol() {
        return this.proto;
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public byte[] getKey() {
        return this.key;
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.key == null && (this.flags & 0xC000) != 49152) {
            return;
        }
        dataByteOutputStream.writeShort(this.flags);
        dataByteOutputStream.writeByte(this.proto);
        dataByteOutputStream.writeByte(this.alg);
        if (this.key != null) {
            dataByteOutputStream.write(this.key);
        }
    }

    private KEYRecord() {
    }

    public KEYRecord(Name name, short s, int n, int n2, int n3, int n4, byte[] byArray) {
        super(name, (short)25, s, n);
        this.flags = (short)n2;
        this.proto = (byte)n3;
        this.alg = (byte)n4;
        this.key = byArray;
    }

    KEYRecord(Name name, short s, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, (short)25, s, n);
        if (dataByteInputStream == null) {
            return;
        }
        this.flags = dataByteInputStream.readShort();
        this.proto = dataByteInputStream.readByte();
        this.alg = dataByteInputStream.readByte();
        if (n2 > 4) {
            this.key = new byte[n2 - 4];
            dataByteInputStream.read(this.key);
        }
    }

    KEYRecord(Name name, short s, int n, MyStringTokenizer myStringTokenizer, Name name2) throws IOException {
        super(name, (short)25, s, n);
        this.flags = (short)Integer.decode(myStringTokenizer.nextToken()).intValue();
        this.proto = (byte)Integer.parseInt(myStringTokenizer.nextToken());
        this.alg = (byte)Integer.parseInt(myStringTokenizer.nextToken());
        this.key = (byte[])((this.flags & 0xC000) != 49152 ? base64.fromString(myStringTokenizer.remainingTokens()) : null);
    }
}

