/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class LOCRecord
extends Record {
    private long size;
    private long hPrecision;
    private long vPrecision;
    private int latitude;
    private int longitude;
    private int altitude;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.latitude != 0 || this.longitude != 0 || this.altitude != 0) {
            char c;
            DecimalFormat decimalFormat = new DecimalFormat();
            ((NumberFormat)decimalFormat).setMaximumFractionDigits(3);
            ((NumberFormat)decimalFormat).setGroupingUsed(false);
            long l = (this.latitude & 0xFFFFFFFF) - Integer.MIN_VALUE;
            if (l < 0L) {
                l = -l;
                c = 'S';
            } else {
                c = 'N';
            }
            stringBuffer.append(l / 3600000L);
            stringBuffer.append(" ");
            stringBuffer.append((l %= 3600000L) / 60000L);
            stringBuffer.append(" ");
            stringBuffer.append(decimalFormat.format((double)(l %= 60000L) / 1000.0));
            stringBuffer.append(" ");
            stringBuffer.append(c);
            stringBuffer.append(" ");
            l = (this.longitude & 0xFFFFFFFF) - Integer.MIN_VALUE;
            if (l < 0L) {
                l = -l;
                c = 'W';
            } else {
                c = 'E';
            }
            stringBuffer.append(l / 3600000L);
            stringBuffer.append(" ");
            stringBuffer.append((l %= 3600000L) / 60000L);
            stringBuffer.append(" ");
            stringBuffer.append(decimalFormat.format((double)(l %= 60000L) / 1000.0));
            stringBuffer.append(" ");
            stringBuffer.append(c);
            stringBuffer.append(" ");
            ((NumberFormat)decimalFormat).setMaximumFractionDigits(2);
            stringBuffer.append(decimalFormat.format((double)(this.altitude - 10000000) / 100.0));
            stringBuffer.append("m ");
            stringBuffer.append(decimalFormat.format((double)this.size / 100.0));
            stringBuffer.append("m ");
            stringBuffer.append(decimalFormat.format((double)this.hPrecision / 100.0));
            stringBuffer.append("m ");
            stringBuffer.append(decimalFormat.format((double)this.vPrecision / 100.0));
            stringBuffer.append("m");
        }
        return stringBuffer.toString();
    }

    public double getLatitude() {
        return (double)(this.latitude - Integer.MIN_VALUE) / 3600000.0;
    }

    public double getLongitude() {
        return (double)(this.longitude - Integer.MIN_VALUE) / 3600000.0;
    }

    public double getAltitude() {
        return (double)(this.altitude - 10000000) / 100.0;
    }

    public double getSize() {
        return (double)this.size / 100.0;
    }

    public double getHPrecision() {
        return (double)this.hPrecision / 100.0;
    }

    public double getVPrecision() {
        return (double)this.vPrecision / 100.0;
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.latitude == 0 && this.longitude == 0 && this.altitude == 0) {
            return;
        }
        dataByteOutputStream.writeByte(0);
        dataByteOutputStream.writeByte(this.toLOCformat(this.size));
        dataByteOutputStream.writeByte(this.toLOCformat(this.hPrecision));
        dataByteOutputStream.writeByte(this.toLOCformat(this.vPrecision));
        dataByteOutputStream.writeInt(this.latitude);
        dataByteOutputStream.writeInt(this.longitude);
        dataByteOutputStream.writeInt(this.altitude);
    }

    /*
     * Unable to fully structure code
     */
    private long parseLOCformat(int var1_1) throws WireParseException {
        var2_2 = var1_1 >> 4;
        var4_3 = var1_1 & 15;
        if (var2_2 <= 9L && var4_3 <= 9) ** GOTO lbl6
        throw new WireParseException("Invalid LOC Encoding");
lbl-1000:
        // 1 sources

        {
            var2_2 *= 10L;
lbl6:
            // 2 sources

            ** while (var4_3-- > 0)
        }
lbl7:
        // 1 sources

        return var2_2;
    }

    private byte toLOCformat(long l) {
        int n = 0;
        while (l > 9L) {
            n = (byte)(n + 1);
            l = (l + 5L) / 10L;
        }
        return (byte)((l << 4) + (long)n);
    }

    private LOCRecord() {
    }

    public LOCRecord(Name name, short s, int n, double d, double d2, double d3, double d4, double d5, double d6) throws IOException {
        super(name, (short)29, s, n);
        this.latitude = (int)(d * 3600.0 * 1000.0 + -2.147483648E9);
        this.longitude = (int)(d2 * 3600.0 * 1000.0 + -2.147483648E9);
        this.altitude = (int)((d3 + 100000.0) * 100.0);
        this.size = (long)(d4 * 100.0);
        this.hPrecision = (long)(d5 * 100.0);
        this.vPrecision = (long)(d6 * 100.0);
    }

    LOCRecord(Name name, short s, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, (short)29, s, n);
        if (dataByteInputStream == null) {
            return;
        }
        byte by = dataByteInputStream.readByte();
        if (by != 0) {
            throw new WireParseException("Invalid LOC version");
        }
        this.size = this.parseLOCformat(dataByteInputStream.readUnsignedByte());
        this.hPrecision = this.parseLOCformat(dataByteInputStream.readUnsignedByte());
        this.vPrecision = this.parseLOCformat(dataByteInputStream.readUnsignedByte());
        this.latitude = dataByteInputStream.readInt();
        this.longitude = dataByteInputStream.readInt();
        this.altitude = dataByteInputStream.readInt();
    }

    LOCRecord(Name name, short s, int n, MyStringTokenizer myStringTokenizer, Name name2) throws IOException {
        super(name, (short)29, s, n);
        String string = null;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        try {
            string = myStringTokenizer.nextToken();
            n3 = Integer.parseInt(string);
            string = myStringTokenizer.nextToken();
            n2 = Integer.parseInt(string);
            string = myStringTokenizer.nextToken();
            d = new Double(string);
            string = myStringTokenizer.nextToken();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!string.equalsIgnoreCase("S") && !string.equalsIgnoreCase("N")) {
            throw new WireParseException("Invalid LOC latitude");
        }
        this.latitude = (int)(1000.0 * (d + (double)(60 * (n2 + 60 * n3))));
        if (string.equalsIgnoreCase("S")) {
            this.latitude = -this.latitude;
        }
        this.latitude += Integer.MIN_VALUE;
        n2 = 0;
        n3 = 0;
        d = 0.0;
        try {
            string = myStringTokenizer.nextToken();
            n3 = Integer.parseInt(string);
            string = myStringTokenizer.nextToken();
            n2 = Integer.parseInt(string);
            string = myStringTokenizer.nextToken();
            d = new Double(string);
            string = myStringTokenizer.nextToken();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!string.equalsIgnoreCase("W") && !string.equalsIgnoreCase("E")) {
            throw new WireParseException("Invalid LOC longitude");
        }
        this.longitude = (int)(1000.0 * (d + (double)(60 * (n2 + 60 * n3))));
        if (string.equalsIgnoreCase("W")) {
            this.longitude = -this.longitude;
        }
        this.longitude += Integer.MIN_VALUE;
        if (!myStringTokenizer.hasMoreTokens()) {
            return;
        }
        string = myStringTokenizer.nextToken();
        if (string.length() > 1 && string.charAt(string.length() - 1) == 'm') {
            string = string.substring(0, string.length() - 1);
        }
        try {
            this.altitude = (int)((new Double(string) + 100000.0) * 100.0);
        }
        catch (NumberFormatException numberFormatException) {
            throw new WireParseException("Invalid LOC altitude");
        }
        if (!myStringTokenizer.hasMoreTokens()) {
            return;
        }
        string = myStringTokenizer.nextToken();
        if (string.length() > 1 && string.charAt(string.length() - 1) == 'm') {
            string = string.substring(0, string.length() - 1);
        }
        try {
            this.size = (int)(100.0 * new Double(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new WireParseException("Invalid LOC size");
        }
        if (!myStringTokenizer.hasMoreTokens()) {
            return;
        }
        string = myStringTokenizer.nextToken();
        if (string.length() > 1 && string.charAt(string.length() - 1) == 'm') {
            string = string.substring(0, string.length() - 1);
        }
        try {
            this.hPrecision = (int)(100.0 * new Double(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new WireParseException("Invalid LOC horizontal precision");
        }
        if (!myStringTokenizer.hasMoreTokens()) {
            return;
        }
        string = myStringTokenizer.nextToken();
        if (string.length() > 1 && string.charAt(string.length() - 1) == 'm') {
            string = string.substring(0, string.length() - 1);
        }
        try {
            this.vPrecision = (int)(100.0 * new Double(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new WireParseException("Invalid LOC vertical precision");
        }
    }
}

