/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TTL;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.MyStringTokenizer;

public class Master {
    private Name origin;
    private BufferedReader br;
    private File file;
    private Record last = null;
    private int defaultTTL = 3600;
    private Master included = null;

    public Record nextRecord() throws IOException {
        String string;
        MyStringTokenizer myStringTokenizer;
        boolean bl;
        if (this.included != null) {
            Record record = this.included.nextRecord();
            if (record != null) {
                return record;
            }
            this.included = null;
        }
        while (true) {
            String string2;
            if ((string2 = Master.readExtendedLine(this.br)) == null) {
                return null;
            }
            if (string2.length() == 0 || string2.startsWith(";")) continue;
            bl = string2.startsWith(" ") || string2.startsWith("\t");
            myStringTokenizer = new MyStringTokenizer(string2);
            string = myStringTokenizer.nextToken();
            if (string.equals("$ORIGIN")) {
                this.origin = this.parseOrigin(myStringTokenizer);
                continue;
            }
            if (!string.equals("$TTL")) break;
            this.defaultTTL = this.parseTTL(myStringTokenizer);
        }
        if (string.equals("$INCLUDE")) {
            this.parseInclude(myStringTokenizer);
            return this.nextRecord();
        }
        if (string.charAt(0) == '$') {
            throw new IOException("Invalid directive: " + string);
        }
        myStringTokenizer.putBackToken(string);
        this.last = this.parseRR(myStringTokenizer, bl, this.last, this.origin);
        return this.last;
    }

    private Name parseOrigin(MyStringTokenizer myStringTokenizer) throws IOException {
        if (!myStringTokenizer.hasMoreTokens()) {
            throw new IOException("Missing ORIGIN");
        }
        return new Name(myStringTokenizer.nextToken());
    }

    private int parseTTL(MyStringTokenizer myStringTokenizer) throws IOException {
        if (!myStringTokenizer.hasMoreTokens()) {
            throw new IOException("Missing TTL");
        }
        return Integer.parseInt(myStringTokenizer.nextToken());
    }

    private void parseInclude(MyStringTokenizer myStringTokenizer) throws IOException {
        if (!myStringTokenizer.hasMoreTokens()) {
            throw new IOException("Missing file to include");
        }
        String string = myStringTokenizer.nextToken();
        File file = this.file.getParent() == null ? new File(string) : new File(this.file.getParent(), string);
        this.included = myStringTokenizer.hasMoreTokens() ? new Master(file, new Name(myStringTokenizer.nextToken())) : new Master(file, this.origin);
    }

    private Record parseRR(MyStringTokenizer myStringTokenizer, boolean bl, Record record, Name name) throws IOException {
        int n;
        Name name2 = !bl ? new Name(myStringTokenizer.nextToken(), name) : record.getName();
        String string = myStringTokenizer.nextToken();
        try {
            n = TTL.parseTTL(string);
            string = myStringTokenizer.nextToken();
        }
        catch (NumberFormatException numberFormatException) {
            n = !bl || record == null ? this.defaultTTL : record.getTTL();
        }
        short s = DClass.value(string);
        if (s > 0) {
            string = myStringTokenizer.nextToken();
        } else {
            s = 1;
        }
        short s2 = Type.value(string);
        if (s2 < 0) {
            throw new IOException("Parse error");
        }
        return Record.fromString(name2, s2, s, n, myStringTokenizer, name);
    }

    private static String stripTrailing(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(59);
        int n2 = n < 0 ? string.length() - 1 : n - 1;
        int n3 = n2;
        while (n3 >= 0) {
            if (!Character.isWhitespace(string.charAt(n3))) {
                return string.substring(0, n3 + 1);
            }
            --n3;
        }
        return "";
    }

    public static String readExtendedLine(BufferedReader bufferedReader) throws IOException {
        String string = Master.stripTrailing(bufferedReader.readLine());
        if (string == null) {
            return null;
        }
        if (!string.endsWith("(")) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, string.length() - 1));
        while (true) {
            if ((string = Master.stripTrailing(bufferedReader.readLine().trim())) == null) {
                return stringBuffer.toString();
            }
            stringBuffer.append(" ");
            if (string.endsWith(")")) break;
            stringBuffer.append(string);
        }
        stringBuffer.append(string.substring(0, string.length() - 1));
        return stringBuffer.toString();
    }

    Master(File file, Name name) throws IOException {
        FileInputStream fileInputStream;
        this.file = file;
        try {
            fileInputStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(fileNotFoundException.toString());
        }
        this.br = new BufferedReader(new InputStreamReader(fileInputStream));
        this.origin = name;
    }

    public Master(String string) throws IOException {
        this(new File(string), null);
    }
}

