/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Header;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Section;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class Message
implements Cloneable {
    private Header header;
    private Vector[] sections = new Vector[4];
    private int size;

    public static Message newQuery(Record record) {
        Message message = new Message();
        message.header.setOpcode((byte)0);
        message.header.setFlag(7);
        message.addRecord(record, 0);
        return message;
    }

    public static Message newUpdate(Name name) {
        Message message = new Message();
        message.header.setOpcode((byte)5);
        Record record = Record.newRecord(name, (short)6, (short)1);
        message.addRecord(record, 0);
        return message;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addRecord(Record record, int n) {
        this.sections[n].addElement(record);
        this.header.incCount(n);
    }

    public boolean removeRecord(Record record, int n) {
        if (this.sections[n].removeElement(record)) {
            this.header.decCount(n);
            return true;
        }
        return false;
    }

    public void removeAllRecords(int n) {
        this.sections[n].setSize(0);
        this.header.setCount(n, 0);
    }

    public boolean findRecord(Record record, int n) {
        return this.sections[n].contains(record);
    }

    public boolean findRecord(Record record) {
        return this.sections[1].contains(record) || this.sections[2].contains(record) || this.sections[3].contains(record);
    }

    public Record getQuestion() {
        try {
            return this.getSectionArray(0)[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public TSIGRecord getTSIG() {
        int n = this.header.getCount(3);
        if (n == 0) {
            return null;
        }
        Vector vector = this.sections[3];
        Record record = (Record)vector.elementAt(n - 1);
        if (record.type != 250) {
            return null;
        }
        return (TSIGRecord)record;
    }

    public OPTRecord getOPT() {
        Record[] recordArray = this.getSectionArray(3);
        int n = 0;
        while (n < recordArray.length) {
            if (recordArray[n] instanceof OPTRecord) {
                return (OPTRecord)recordArray[n];
            }
            ++n;
        }
        return null;
    }

    public Enumeration getSection(int n) {
        return this.sections[n].elements();
    }

    public Record[] getSectionArray(int n) {
        int n2 = this.sections[n].size();
        Record[] recordArray = new Record[n2];
        int n3 = 0;
        while (n3 < n2) {
            recordArray[n3] = (Record)this.sections[n].elementAt(n3);
            ++n3;
        }
        return recordArray;
    }

    void toWire(DataByteOutputStream dataByteOutputStream) throws IOException {
        this.header.toWire(dataByteOutputStream);
        Compression compression = new Compression();
        int n = 0;
        while (n < 4) {
            if (this.sections[n].size() != 0) {
                int n2 = 0;
                while (n2 < this.sections[n].size()) {
                    Record record = (Record)this.sections[n].elementAt(n2);
                    record.toWire(dataByteOutputStream, n, compression);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public byte[] toWire() throws IOException {
        DataByteOutputStream dataByteOutputStream = new DataByteOutputStream();
        this.toWire(dataByteOutputStream);
        this.size = dataByteOutputStream.getPos();
        return dataByteOutputStream.toByteArray();
    }

    public int numBytes() {
        return this.size;
    }

    public String sectionToString(int n) {
        if (n > 3) {
            return null;
        }
        Enumeration enumeration = this.getSection(n);
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            if (n == 0) {
                stringBuffer.append(";;\t" + record.name);
                stringBuffer.append(", type = " + Type.string(record.type));
                stringBuffer.append(", class = " + DClass.string(record.dclass));
            } else {
                stringBuffer.append(record);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHeader() + "\n");
        int n = 0;
        while (n < 4) {
            if (this.header.getOpcode() != 5) {
                stringBuffer.append(";; " + Section.longString(n) + ":\n");
            } else {
                stringBuffer.append(";; " + Section.updString(n) + ":\n");
            }
            stringBuffer.append(this.sectionToString(n) + "\n");
            ++n;
        }
        stringBuffer.append(";; done (" + this.numBytes() + " bytes)");
        return stringBuffer.toString();
    }

    public Object clone() {
        Message message = new Message();
        int n = 0;
        while (n < this.sections.length) {
            message.sections[n] = (Vector)this.sections[n].clone();
            ++n;
        }
        message.header = (Header)this.header.clone();
        message.size = this.size;
        return message;
    }

    public Message(int n) {
        int n2 = 0;
        while (n2 < 4) {
            this.sections[n2] = new Vector();
            ++n2;
        }
        this.header = new Header(n);
    }

    public Message() {
        this(Header.randomID());
    }

    Message(DataByteInputStream dataByteInputStream) throws IOException {
        this();
        Compression compression = new Compression();
        this.header = new Header(dataByteInputStream);
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < this.header.getCount(n)) {
                Record record = Record.fromWire(dataByteInputStream, n, compression);
                this.sections[n].addElement(record);
                ++n2;
            }
            ++n;
        }
        this.size = dataByteInputStream.getPos();
    }

    public Message(byte[] byArray) throws IOException {
        this(new DataByteInputStream(byArray));
    }
}

