/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class OPTRecord
extends Record {
    private Hashtable options;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.options != null) {
            Enumeration enumeration = this.options.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                stringBuffer.append(n + " ");
            }
        }
        return stringBuffer.toString();
    }

    public short getPayloadSize() {
        return this.dclass;
    }

    public short getExtendedRcode() {
        return (short)(this.ttl >>> 24);
    }

    public short getVersion() {
        return (short)(this.ttl >>> 16 & 0xFF);
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.options == null) {
            return;
        }
        Enumeration enumeration = this.options.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            short s = n.shortValue();
            dataByteOutputStream.writeShort(s);
            byte[] byArray = (byte[])this.options.get(n);
            dataByteOutputStream.writeShort(byArray.length);
            dataByteOutputStream.write(byArray);
        }
    }

    void rrToWireCanonical(DataByteOutputStream dataByteOutputStream) throws IOException {
        throw new IOException("An OPT should never be converted to canonical");
    }

    private OPTRecord() {
    }

    public OPTRecord(Name name, short s, int n) {
        super(name, (short)249, s, n);
        this.options = null;
    }

    OPTRecord(Name name, short s, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, (short)249, s, n);
        if (dataByteInputStream == null) {
            return;
        }
        int n3 = 0;
        if (n3 < n2) {
            this.options = new Hashtable();
        }
        while (n3 < n2) {
            int n4 = dataByteInputStream.readUnsignedShort();
            int n5 = dataByteInputStream.readUnsignedShort();
            byte[] byArray = new byte[n5];
            dataByteInputStream.read(byArray);
            n3 += 4 + n5;
            this.options.put(new Integer(n4), byArray);
        }
    }
}

